/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-indicator-model.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */


#ifndef __UNITY_WEBAPPS_INDICATOR_MODEL_CONTROLLER_H
#define __UNITY_WEBAPPS_INDICATOR_MODEL_CONTROLLER_H

#include "unity-webapps-indicator-model.h"
#include "unity-webapps-interest-manager.h"


#define UNITY_WEBAPPS_TYPE_INDICATOR_MODEL_CONTROLLER              (unity_webapps_indicator_model_controller_get_type())
#define UNITY_WEBAPPS_INDICATOR_MODEL_CONTROLLER(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), UNITY_WEBAPPS_TYPE_INDICATOR_MODEL_CONTROLLER, UnityWebappsIndicatorModelController))
#define UNITY_WEBAPPS_INDICATOR_MODEL_CONTROLLER_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), UNITY_WEBAPPS_TYPE_INDICATOR_MODEL_CONTROLLER, UnityWebappsIndicatorModelControllerClass))
#define UNITY_WEBAPPS_IS_INDICATOR_MODEL_CONTROLLER(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), UNITY_WEBAPPS_TYPE_INDICATOR_MODEL_CONTROLLER))
#define UNITY_WEBAPPS_IS_INDICATOR_MODEL_CONTROLLER_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPPS_TYPE_INDICATOR_MODEL_CONTROLLER))
#define UNITY_WEBAPPS_INDICATOR_MODEL_CONTROLLER_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), UNITY_WEBAPPS_TYPE_INDICATOR_MODEL_CONTROLLER, UnityWebappsIndicatorModelControllerClass))

typedef struct _UnityWebappsIndicatorModelControllerPrivate UnityWebappsIndicatorModelControllerPrivate;

typedef struct _UnityWebappsIndicatorModelController UnityWebappsIndicatorModelController;


struct _UnityWebappsIndicatorModelController {
	GObject object;

	UnityWebappsIndicatorModelControllerPrivate *priv;
};

typedef struct _UnityWebappsIndicatorModelControllerClass UnityWebappsIndicatorModelControllerClass;

struct _UnityWebappsIndicatorModelControllerClass
{
	GObjectClass parent_class;
};

GType unity_webapps_indicator_model_controller_get_type (void) G_GNUC_CONST;

UnityWebappsIndicatorModelController *unity_webapps_indicator_model_controller_new (UnityWebappsIndicatorModel *model, UnityWebappsInterestManager *manager);

UnityWebappsIndicatorModel *unity_webapps_indicator_model_controller_get_model (UnityWebappsIndicatorModelController *controller);
UnityWebappsInterestManager *unity_webapps_indicator_model_controller_get_interest_manager (UnityWebappsIndicatorModelController *controller);



#endif
