; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes='sroa<preserve-cfg>' -S | FileCheck %s --check-prefixes=CHECK,CHECK-PRESERVE-CFG
; RUN: opt < %s -passes='sroa<modify-cfg>' -S | FileCheck %s --check-prefixes=CHECK,CHECK-MODIFY-CFG

target datalayout = "e-p:64:64:64-p1:16:16:16-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-n8:16:32:64"

declare void @llvm.lifetime.start.p0(i64, ptr nocapture)
declare void @llvm.lifetime.end.p0(i64, ptr nocapture)

define i32 @test0() {
; CHECK-LABEL: @test0(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[V2_INT:%.*]] = bitcast float 0.000000e+00 to i32
; CHECK-NEXT:    [[SUM1:%.*]] = add i32 0, [[V2_INT]]
; CHECK-NEXT:    ret i32 [[SUM1]]
;
entry:
  %a1 = alloca i32
  %a2 = alloca float

  call void @llvm.lifetime.start.p0(i64 4, ptr %a1)

  store i32 0, ptr %a1
  %v1 = load i32, ptr %a1

  call void @llvm.lifetime.end.p0(i64 4, ptr %a1)

  call void @llvm.lifetime.start.p0(i64 4, ptr %a2)

  store float 0.0, ptr %a2
  %v2 = load float , ptr %a2
  %v2.int = bitcast float %v2 to i32
  %sum1 = add i32 %v1, %v2.int

  call void @llvm.lifetime.end.p0(i64 4, ptr %a2)

  ret i32 %sum1
}

define i32 @test1() {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret i32 0
;
entry:
  %X = alloca { i32, float }
  %Y = getelementptr { i32, float }, ptr %X, i64 0, i32 0
  store i32 0, ptr %Y
  %Z = load i32, ptr %Y
  ret i32 %Z
}

define i64 @test2(i64 %X) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[L2:%.*]]
; CHECK:       L2:
; CHECK-NEXT:    ret i64 [[X:%.*]]
;
entry:
  %A = alloca [8 x i8]
  store i64 %X, ptr %A
  br label %L2

L2:
  %Z = load i64, ptr %A
  ret i64 %Z
}

define i64 @test2_addrspacecast(i64 %X) {
; CHECK-LABEL: @test2_addrspacecast(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[L2:%.*]]
; CHECK:       L2:
; CHECK-NEXT:    ret i64 [[X:%.*]]
;
entry:
  %A = alloca [8 x i8]
  %B = addrspacecast ptr %A to ptr addrspace(1)
  store i64 %X, ptr addrspace(1) %B
  br label %L2

L2:
  %Z = load i64, ptr addrspace(1) %B
  ret i64 %Z
}

define i64 @test2_addrspacecast_gep(i64 %X, i16 %idx) {
; CHECK-LABEL: @test2_addrspacecast_gep(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[L2:%.*]]
; CHECK:       L2:
; CHECK-NEXT:    ret i64 [[X:%.*]]
;
entry:
  %A = alloca [256 x i8]
  %B = addrspacecast ptr %A to ptr addrspace(1)
  %gepA = getelementptr [256 x i8], ptr %A, i16 0, i16 32
  %gepB = getelementptr i64, ptr addrspace(1) %B, i16 4
  store i64 %X, ptr addrspace(1) %gepB, align 1
  br label %L2

L2:
  %Z = load i64, ptr %gepA, align 1
  ret i64 %Z
}

; Avoid crashing when load/storing at at different offsets.
define i64 @test2_addrspacecast_gep_offset(i64 %X) {
; CHECK-LABEL: @test2_addrspacecast_gep_offset(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SROA_0:%.*]] = alloca [10 x i8], align 1
; CHECK-NEXT:    [[A_SROA_0_2_GEPB_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_0]], i16 2
; CHECK-NEXT:    [[A_SROA_0_2_GEPB_SROA_CAST:%.*]] = addrspacecast ptr [[A_SROA_0_2_GEPB_SROA_IDX]] to ptr addrspace(1)
; CHECK-NEXT:    store i64 [[X:%.*]], ptr addrspace(1) [[A_SROA_0_2_GEPB_SROA_CAST]], align 1
; CHECK-NEXT:    br label [[L2:%.*]]
; CHECK:       L2:
; CHECK-NEXT:    [[A_SROA_0_0_A_SROA_0_30_Z:%.*]] = load i64, ptr [[A_SROA_0]], align 1
; CHECK-NEXT:    ret i64 [[A_SROA_0_0_A_SROA_0_30_Z]]
;
entry:
  %A = alloca [256 x i8]
  %B = addrspacecast ptr %A to ptr addrspace(1)
  %gepA = getelementptr [256 x i8], ptr %A, i16 0, i16 30
  %gepB = getelementptr i64, ptr addrspace(1) %B, i16 4
  store i64 %X, ptr addrspace(1) %gepB, align 1
  br label %L2

L2:
  %Z = load i64, ptr %gepA, align 1
  ret i64 %Z
}

define void @test3(ptr %dst, ptr align 8 %src) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SROA_0:%.*]] = alloca [42 x i8], align 1
; CHECK-NEXT:    [[A_SROA_3:%.*]] = alloca [99 x i8], align 1
; CHECK-NEXT:    [[A_SROA_32:%.*]] = alloca [16 x i8], align 1
; CHECK-NEXT:    [[A_SROA_15:%.*]] = alloca [42 x i8], align 1
; CHECK-NEXT:    [[A_SROA_16:%.*]] = alloca [7 x i8], align 1
; CHECK-NEXT:    [[A_SROA_235:%.*]] = alloca [7 x i8], align 1
; CHECK-NEXT:    [[A_SROA_31:%.*]] = alloca [85 x i8], align 1
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_0]], ptr align 8 [[SRC:%.*]], i32 42, i1 false), !tbaa [[TBAA0:![0-9]+]]
; CHECK-NEXT:    [[A_SROA_2_0_SRC_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[SRC]], i64 42
; CHECK-NEXT:    [[A_SROA_2_0_COPYLOAD:%.*]] = load i8, ptr [[A_SROA_2_0_SRC_SROA_IDX]], align 2, !tbaa [[TBAA0]]
; CHECK-NEXT:    [[A_SROA_3_0_SRC_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[SRC]], i64 43
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_3]], ptr align 1 [[A_SROA_3_0_SRC_SROA_IDX]], i32 99, i1 false), !tbaa [[TBAA0]]
; CHECK-NEXT:    [[A_SROA_32_0_SRC_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[SRC]], i64 142
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_32]], ptr align 2 [[A_SROA_32_0_SRC_SROA_IDX]], i32 16, i1 false), !tbaa [[TBAA0]]
; CHECK-NEXT:    [[A_SROA_15_0_SRC_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[SRC]], i64 158
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_15]], ptr align 2 [[A_SROA_15_0_SRC_SROA_IDX]], i32 42, i1 false), !tbaa [[TBAA0]]
; CHECK-NEXT:    [[A_SROA_16_0_SRC_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[SRC]], i64 200
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_16]], ptr align 8 [[A_SROA_16_0_SRC_SROA_IDX]], i32 7, i1 false), !tbaa [[TBAA0]]
; CHECK-NEXT:    [[A_SROA_23_0_SRC_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[SRC]], i64 207
; CHECK-NEXT:    [[A_SROA_23_0_COPYLOAD:%.*]] = load i8, ptr [[A_SROA_23_0_SRC_SROA_IDX]], align 1, !tbaa [[TBAA0]]
; CHECK-NEXT:    [[A_SROA_235_0_SRC_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[SRC]], i64 208
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_235]], ptr align 8 [[A_SROA_235_0_SRC_SROA_IDX]], i32 7, i1 false), !tbaa [[TBAA0]]
; CHECK-NEXT:    [[A_SROA_31_0_SRC_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[SRC]], i64 215
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_31]], ptr align 1 [[A_SROA_31_0_SRC_SROA_IDX]], i32 85, i1 false), !tbaa [[TBAA0]]
; CHECK-NEXT:    store i8 1, ptr [[A_SROA_32]], align 1, !tbaa [[TBAA3:![0-9]+]]
; CHECK-NEXT:    store i16 1, ptr [[A_SROA_32]], align 1, !tbaa [[TBAA5:![0-9]+]]
; CHECK-NEXT:    store i32 1, ptr [[A_SROA_32]], align 1, !tbaa [[TBAA7:![0-9]+]]
; CHECK-NEXT:    store i64 1, ptr [[A_SROA_32]], align 1, !tbaa [[TBAA9:![0-9]+]]
; CHECK-NEXT:    [[A_SROA_32_1_OVERLAP_2_I8_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_32]], i64 1
; CHECK-NEXT:    store i64 2, ptr [[A_SROA_32_1_OVERLAP_2_I8_SROA_IDX]], align 1, !tbaa [[TBAA11:![0-9]+]]
; CHECK-NEXT:    [[A_SROA_32_2_OVERLAP_3_I8_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_32]], i64 2
; CHECK-NEXT:    store i64 3, ptr [[A_SROA_32_2_OVERLAP_3_I8_SROA_IDX]], align 1, !tbaa [[TBAA13:![0-9]+]]
; CHECK-NEXT:    [[A_SROA_32_3_OVERLAP_4_I8_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_32]], i64 3
; CHECK-NEXT:    store i64 4, ptr [[A_SROA_32_3_OVERLAP_4_I8_SROA_IDX]], align 1, !tbaa [[TBAA15:![0-9]+]]
; CHECK-NEXT:    [[A_SROA_32_4_OVERLAP_5_I8_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_32]], i64 4
; CHECK-NEXT:    store i64 5, ptr [[A_SROA_32_4_OVERLAP_5_I8_SROA_IDX]], align 1, !tbaa [[TBAA17:![0-9]+]]
; CHECK-NEXT:    [[A_SROA_32_5_OVERLAP_6_I8_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_32]], i64 5
; CHECK-NEXT:    store i64 6, ptr [[A_SROA_32_5_OVERLAP_6_I8_SROA_IDX]], align 1, !tbaa [[TBAA19:![0-9]+]]
; CHECK-NEXT:    [[A_SROA_32_6_OVERLAP_7_I8_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_32]], i64 6
; CHECK-NEXT:    store i64 7, ptr [[A_SROA_32_6_OVERLAP_7_I8_SROA_IDX]], align 1, !tbaa [[TBAA21:![0-9]+]]
; CHECK-NEXT:    [[A_SROA_32_7_OVERLAP_8_I8_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_32]], i64 7
; CHECK-NEXT:    store i64 8, ptr [[A_SROA_32_7_OVERLAP_8_I8_SROA_IDX]], align 1, !tbaa [[TBAA23:![0-9]+]]
; CHECK-NEXT:    [[A_SROA_32_8_OVERLAP_9_I8_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_32]], i64 8
; CHECK-NEXT:    store i64 9, ptr [[A_SROA_32_8_OVERLAP_9_I8_SROA_IDX]], align 1, !tbaa [[TBAA25:![0-9]+]]
; CHECK-NEXT:    store i8 1, ptr [[A_SROA_16]], align 1, !tbaa [[TBAA27:![0-9]+]]
; CHECK-NEXT:    store i16 1, ptr [[A_SROA_16]], align 1, !tbaa [[TBAA29:![0-9]+]]
; CHECK-NEXT:    store i32 1, ptr [[A_SROA_16]], align 1, !tbaa [[TBAA31:![0-9]+]]
; CHECK-NEXT:    [[A_SROA_16_1_OVERLAP2_1_1_I8_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_16]], i64 1
; CHECK-NEXT:    store i32 2, ptr [[A_SROA_16_1_OVERLAP2_1_1_I8_SROA_IDX]], align 1, !tbaa [[TBAA33:![0-9]+]]
; CHECK-NEXT:    [[A_SROA_16_2_OVERLAP2_1_2_I8_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_16]], i64 2
; CHECK-NEXT:    store i32 3, ptr [[A_SROA_16_2_OVERLAP2_1_2_I8_SROA_IDX]], align 1, !tbaa [[TBAA35:![0-9]+]]
; CHECK-NEXT:    [[A_SROA_16_3_OVERLAP2_1_3_I8_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_16]], i64 3
; CHECK-NEXT:    store i32 4, ptr [[A_SROA_16_3_OVERLAP2_1_3_I8_SROA_IDX]], align 1, !tbaa [[TBAA37:![0-9]+]]
; CHECK-NEXT:    store i32 1, ptr [[A_SROA_235]], align 1, !tbaa [[TBAA39:![0-9]+]]
; CHECK-NEXT:    [[A_SROA_235_1_OVERLAP2_2_1_I8_SROA_IDX11:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_235]], i64 1
; CHECK-NEXT:    store i8 1, ptr [[A_SROA_235_1_OVERLAP2_2_1_I8_SROA_IDX11]], align 1, !tbaa [[TBAA41:![0-9]+]]
; CHECK-NEXT:    [[A_SROA_235_1_OVERLAP2_2_1_I8_SROA_IDX10:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_235]], i64 1
; CHECK-NEXT:    store i16 1, ptr [[A_SROA_235_1_OVERLAP2_2_1_I8_SROA_IDX10]], align 1, !tbaa [[TBAA43:![0-9]+]]
; CHECK-NEXT:    [[A_SROA_235_1_OVERLAP2_2_1_I8_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_235]], i64 1
; CHECK-NEXT:    store i32 1, ptr [[A_SROA_235_1_OVERLAP2_2_1_I8_SROA_IDX]], align 1, !tbaa [[TBAA45:![0-9]+]]
; CHECK-NEXT:    [[A_SROA_235_2_OVERLAP2_2_2_I8_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_235]], i64 2
; CHECK-NEXT:    store i32 3, ptr [[A_SROA_235_2_OVERLAP2_2_2_I8_SROA_IDX]], align 1, !tbaa [[TBAA47:![0-9]+]]
; CHECK-NEXT:    [[A_SROA_235_3_OVERLAP2_2_3_I8_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_235]], i64 3
; CHECK-NEXT:    store i32 4, ptr [[A_SROA_235_3_OVERLAP2_2_3_I8_SROA_IDX]], align 1, !tbaa [[TBAA49:![0-9]+]]
; CHECK-NEXT:    [[A_SROA_15_197_OVERLAP2_PREFIX_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_15]], i64 39
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_15_197_OVERLAP2_PREFIX_SROA_IDX]], ptr align 1 [[SRC]], i32 3, i1 false), !tbaa [[TBAA51:![0-9]+]]
; CHECK-NEXT:    [[A_SROA_16_197_SRC_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[SRC]], i64 3
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_16]], ptr align 1 [[A_SROA_16_197_SRC_SROA_IDX]], i32 5, i1 false), !tbaa [[TBAA51]]
; CHECK-NEXT:    [[A_SROA_16_2_OVERLAP2_1_2_I8_SROA_IDX12:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_16]], i64 2
; CHECK-NEXT:    call void @llvm.memset.p0.i32(ptr align 1 [[A_SROA_16_2_OVERLAP2_1_2_I8_SROA_IDX12]], i8 42, i32 5, i1 false), !tbaa [[TBAA53:![0-9]+]]
; CHECK-NEXT:    call void @llvm.memset.p0.i32(ptr align 1 [[A_SROA_235]], i8 42, i32 2, i1 false), !tbaa [[TBAA53]]
; CHECK-NEXT:    [[A_SROA_235_209_OVERLAP2_2_1_I8_SROA_IDX8:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_235]], i64 1
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_235_209_OVERLAP2_2_1_I8_SROA_IDX8]], ptr align 1 [[SRC]], i32 5, i1 false), !tbaa [[TBAA55:![0-9]+]]
; CHECK-NEXT:    [[A_SROA_235_210_OVERLAP2_2_2_I8_SROA_IDX9:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_235]], i64 2
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_235_210_OVERLAP2_2_2_I8_SROA_IDX9]], ptr align 1 [[SRC]], i32 5, i1 false), !tbaa [[TBAA57:![0-9]+]]
; CHECK-NEXT:    [[A_SROA_31_210_SRC_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[SRC]], i64 5
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_31]], ptr align 1 [[A_SROA_31_210_SRC_SROA_IDX]], i32 3, i1 false), !tbaa [[TBAA57]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[DST:%.*]], ptr align 1 [[A_SROA_0]], i32 42, i1 false), !tbaa [[TBAA59:![0-9]+]]
; CHECK-NEXT:    [[A_SROA_2_0_DST_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[DST]], i64 42
; CHECK-NEXT:    store i8 0, ptr [[A_SROA_2_0_DST_SROA_IDX]], align 1, !tbaa [[TBAA59]]
; CHECK-NEXT:    [[A_SROA_3_0_DST_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[DST]], i64 43
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_3_0_DST_SROA_IDX]], ptr align 1 [[A_SROA_3]], i32 99, i1 false), !tbaa [[TBAA59]]
; CHECK-NEXT:    [[A_SROA_32_0_DST_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[DST]], i64 142
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_32_0_DST_SROA_IDX]], ptr align 1 [[A_SROA_32]], i32 16, i1 false), !tbaa [[TBAA59]]
; CHECK-NEXT:    [[A_SROA_15_0_DST_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[DST]], i64 158
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_15_0_DST_SROA_IDX]], ptr align 1 [[A_SROA_15]], i32 42, i1 false), !tbaa [[TBAA59]]
; CHECK-NEXT:    [[A_SROA_16_0_DST_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[DST]], i64 200
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_16_0_DST_SROA_IDX]], ptr align 1 [[A_SROA_16]], i32 7, i1 false), !tbaa [[TBAA59]]
; CHECK-NEXT:    [[A_SROA_23_0_DST_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[DST]], i64 207
; CHECK-NEXT:    store i8 42, ptr [[A_SROA_23_0_DST_SROA_IDX]], align 1, !tbaa [[TBAA59]]
; CHECK-NEXT:    [[A_SROA_235_0_DST_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[DST]], i64 208
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_235_0_DST_SROA_IDX]], ptr align 1 [[A_SROA_235]], i32 7, i1 false), !tbaa [[TBAA59]]
; CHECK-NEXT:    [[A_SROA_31_0_DST_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[DST]], i64 215
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_31_0_DST_SROA_IDX]], ptr align 1 [[A_SROA_31]], i32 85, i1 false), !tbaa [[TBAA59]]
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca [300 x i8]

  call void @llvm.memcpy.p0.p0.i32(ptr %a, ptr align 8 %src, i32 300, i1 false), !tbaa !0

  ; Clobber a single element of the array, this should be promotable, and be deleted.
  %c = getelementptr [300 x i8], ptr %a, i64 0, i64 42
  store i8 0, ptr %c

  ; Make a sequence of overlapping stores to the array. These overlap both in
  ; forward strides and in shrinking accesses.
  %overlap.1.i8 = getelementptr [300 x i8], ptr %a, i64 0, i64 142
  %overlap.2.i8 = getelementptr [300 x i8], ptr %a, i64 0, i64 143
  %overlap.3.i8 = getelementptr [300 x i8], ptr %a, i64 0, i64 144
  %overlap.4.i8 = getelementptr [300 x i8], ptr %a, i64 0, i64 145
  %overlap.5.i8 = getelementptr [300 x i8], ptr %a, i64 0, i64 146
  %overlap.6.i8 = getelementptr [300 x i8], ptr %a, i64 0, i64 147
  %overlap.7.i8 = getelementptr [300 x i8], ptr %a, i64 0, i64 148
  %overlap.8.i8 = getelementptr [300 x i8], ptr %a, i64 0, i64 149
  %overlap.9.i8 = getelementptr [300 x i8], ptr %a, i64 0, i64 150
  store i8 1, ptr %overlap.1.i8, !tbaa !3
  store i16 1, ptr %overlap.1.i8, !tbaa !5
  store i32 1, ptr %overlap.1.i8, !tbaa !7
  store i64 1, ptr %overlap.1.i8, !tbaa !9
  store i64 2, ptr %overlap.2.i8, !tbaa !11
  store i64 3, ptr %overlap.3.i8, !tbaa !13
  store i64 4, ptr %overlap.4.i8, !tbaa !15
  store i64 5, ptr %overlap.5.i8, !tbaa !17
  store i64 6, ptr %overlap.6.i8, !tbaa !19
  store i64 7, ptr %overlap.7.i8, !tbaa !21
  store i64 8, ptr %overlap.8.i8, !tbaa !23
  store i64 9, ptr %overlap.9.i8, !tbaa !25

  ; Make two sequences of overlapping stores with more gaps and irregularities.
  %overlap2.1.0.i8 = getelementptr [300 x i8], ptr %a, i64 0, i64 200
  %overlap2.1.1.i8 = getelementptr [300 x i8], ptr %a, i64 0, i64 201
  %overlap2.1.2.i8 = getelementptr [300 x i8], ptr %a, i64 0, i64 202
  %overlap2.1.3.i8 = getelementptr [300 x i8], ptr %a, i64 0, i64 203

  %overlap2.2.0.i8 = getelementptr [300 x i8], ptr %a, i64 0, i64 208
  %overlap2.2.1.i8 = getelementptr [300 x i8], ptr %a, i64 0, i64 209
  %overlap2.2.2.i8 = getelementptr [300 x i8], ptr %a, i64 0, i64 210
  %overlap2.2.3.i8 = getelementptr [300 x i8], ptr %a, i64 0, i64 211

  store i8 1,  ptr  %overlap2.1.0.i8, !tbaa !27
  store i16 1, ptr %overlap2.1.0.i8, !tbaa !29
  store i32 1, ptr %overlap2.1.0.i8, !tbaa !31
  store i32 2, ptr %overlap2.1.1.i8, !tbaa !33
  store i32 3, ptr %overlap2.1.2.i8, !tbaa !35
  store i32 4, ptr %overlap2.1.3.i8, !tbaa !37

  store i32 1, ptr %overlap2.2.0.i8, !tbaa !39
  store i8 1,  ptr  %overlap2.2.1.i8, !tbaa !41
  store i16 1, ptr %overlap2.2.1.i8, !tbaa !43
  store i32 1, ptr %overlap2.2.1.i8, !tbaa !45
  store i32 3, ptr %overlap2.2.2.i8, !tbaa !47
  store i32 4, ptr %overlap2.2.3.i8, !tbaa !49

  %overlap2.prefix = getelementptr i8, ptr %overlap2.1.1.i8, i64 -4
  call void @llvm.memcpy.p0.p0.i32(ptr %overlap2.prefix, ptr %src, i32 8, i1 false), !tbaa !51

  ; Bridge between the overlapping areas
  call void @llvm.memset.p0.i32(ptr %overlap2.1.2.i8, i8 42, i32 8, i1 false), !tbaa !53
; ...promoted i8 store...

  ; Entirely within the second overlap.
  call void @llvm.memcpy.p0.p0.i32(ptr %overlap2.2.1.i8, ptr %src, i32 5, i1 false), !tbaa !55

  ; Trailing past the second overlap.
  call void @llvm.memcpy.p0.p0.i32(ptr %overlap2.2.2.i8, ptr %src, i32 8, i1 false), !tbaa !57

  call void @llvm.memcpy.p0.p0.i32(ptr %dst, ptr %a, i32 300, i1 false), !tbaa !59

  ret void
}

define void @test4(ptr %dst, ptr %src) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SROA_0:%.*]] = alloca [20 x i8], align 1
; CHECK-NEXT:    [[A_SROA_2_SROA_4:%.*]] = alloca [7 x i8], align 1
; CHECK-NEXT:    [[A_SROA_3:%.*]] = alloca [10 x i8], align 1
; CHECK-NEXT:    [[A_SROA_31_SROA_5:%.*]] = alloca [7 x i8], align 1
; CHECK-NEXT:    [[A_SROA_6_SROA_4:%.*]] = alloca [7 x i8], align 1
; CHECK-NEXT:    [[A_SROA_7:%.*]] = alloca [40 x i8], align 1
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_0]], ptr align 1 [[SRC:%.*]], i32 20, i1 false), !tbaa [[TBAA0]]
; CHECK-NEXT:    [[A_SROA_2_0_SRC_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[SRC]], i64 20
; CHECK-NEXT:    [[A_SROA_2_SROA_0_0_COPYLOAD:%.*]] = load i16, ptr [[A_SROA_2_0_SRC_SROA_IDX]], align 1, !tbaa [[TBAA0]]
; CHECK-NEXT:    [[A_SROA_2_SROA_3_0_A_SROA_2_0_SRC_SROA_IDX_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_2_0_SRC_SROA_IDX]], i64 2
; CHECK-NEXT:    [[A_SROA_2_SROA_3_0_COPYLOAD:%.*]] = load i8, ptr [[A_SROA_2_SROA_3_0_A_SROA_2_0_SRC_SROA_IDX_SROA_IDX]], align 1, !tbaa [[TBAA0]]
; CHECK-NEXT:    [[A_SROA_2_SROA_4_0_A_SROA_2_0_SRC_SROA_IDX_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_2_0_SRC_SROA_IDX]], i64 3
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_2_SROA_4]], ptr align 1 [[A_SROA_2_SROA_4_0_A_SROA_2_0_SRC_SROA_IDX_SROA_IDX]], i32 7, i1 false), !tbaa [[TBAA0]]
; CHECK-NEXT:    [[A_SROA_3_0_SRC_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[SRC]], i64 30
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_3]], ptr align 1 [[A_SROA_3_0_SRC_SROA_IDX]], i32 10, i1 false), !tbaa [[TBAA0]]
; CHECK-NEXT:    [[A_SROA_31_0_SRC_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[SRC]], i64 40
; CHECK-NEXT:    [[A_SROA_31_SROA_0_0_COPYLOAD:%.*]] = load i16, ptr [[A_SROA_31_0_SRC_SROA_IDX]], align 1, !tbaa [[TBAA0]]
; CHECK-NEXT:    [[A_SROA_31_SROA_4_0_A_SROA_31_0_SRC_SROA_IDX_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_31_0_SRC_SROA_IDX]], i64 2
; CHECK-NEXT:    [[A_SROA_31_SROA_4_0_COPYLOAD:%.*]] = load i8, ptr [[A_SROA_31_SROA_4_0_A_SROA_31_0_SRC_SROA_IDX_SROA_IDX]], align 1, !tbaa [[TBAA0]]
; CHECK-NEXT:    [[A_SROA_31_SROA_5_0_A_SROA_31_0_SRC_SROA_IDX_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_31_0_SRC_SROA_IDX]], i64 3
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_31_SROA_5]], ptr align 1 [[A_SROA_31_SROA_5_0_A_SROA_31_0_SRC_SROA_IDX_SROA_IDX]], i32 7, i1 false), !tbaa [[TBAA0]]
; CHECK-NEXT:    [[A_SROA_6_0_SRC_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[SRC]], i64 50
; CHECK-NEXT:    [[A_SROA_6_SROA_0_0_COPYLOAD:%.*]] = load i16, ptr [[A_SROA_6_0_SRC_SROA_IDX]], align 1, !tbaa [[TBAA0]]
; CHECK-NEXT:    [[A_SROA_6_SROA_3_0_A_SROA_6_0_SRC_SROA_IDX_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_6_0_SRC_SROA_IDX]], i64 2
; CHECK-NEXT:    [[A_SROA_6_SROA_3_0_COPYLOAD:%.*]] = load i8, ptr [[A_SROA_6_SROA_3_0_A_SROA_6_0_SRC_SROA_IDX_SROA_IDX]], align 1, !tbaa [[TBAA0]]
; CHECK-NEXT:    [[A_SROA_6_SROA_4_0_A_SROA_6_0_SRC_SROA_IDX_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_6_0_SRC_SROA_IDX]], i64 3
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_6_SROA_4]], ptr align 1 [[A_SROA_6_SROA_4_0_A_SROA_6_0_SRC_SROA_IDX_SROA_IDX]], i32 7, i1 false), !tbaa [[TBAA0]]
; CHECK-NEXT:    [[A_SROA_7_0_SRC_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[SRC]], i64 60
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_7]], ptr align 1 [[A_SROA_7_0_SRC_SROA_IDX]], i32 40, i1 false), !tbaa [[TBAA0]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_31_SROA_5]], ptr align 1 [[A_SROA_2_SROA_4]], i32 7, i1 false), !tbaa [[TBAA3]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_31_SROA_5]], ptr align 1 [[A_SROA_6_SROA_4]], i32 7, i1 false), !tbaa [[TBAA5]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[DST:%.*]], ptr align 1 [[A_SROA_0]], i32 20, i1 false), !tbaa [[TBAA7]]
; CHECK-NEXT:    [[A_SROA_2_0_DST_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[DST]], i64 20
; CHECK-NEXT:    store i16 [[A_SROA_2_SROA_0_0_COPYLOAD]], ptr [[A_SROA_2_0_DST_SROA_IDX]], align 1, !tbaa [[TBAA7]]
; CHECK-NEXT:    [[A_SROA_2_SROA_3_0_A_SROA_2_0_DST_SROA_IDX_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_2_0_DST_SROA_IDX]], i64 2
; CHECK-NEXT:    store i8 [[A_SROA_2_SROA_3_0_COPYLOAD]], ptr [[A_SROA_2_SROA_3_0_A_SROA_2_0_DST_SROA_IDX_SROA_IDX]], align 1, !tbaa [[TBAA7]]
; CHECK-NEXT:    [[A_SROA_2_SROA_4_0_A_SROA_2_0_DST_SROA_IDX_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_2_0_DST_SROA_IDX]], i64 3
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_2_SROA_4_0_A_SROA_2_0_DST_SROA_IDX_SROA_IDX]], ptr align 1 [[A_SROA_2_SROA_4]], i32 7, i1 false), !tbaa [[TBAA7]]
; CHECK-NEXT:    [[A_SROA_3_0_DST_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[DST]], i64 30
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_3_0_DST_SROA_IDX]], ptr align 1 [[A_SROA_3]], i32 10, i1 false), !tbaa [[TBAA7]]
; CHECK-NEXT:    [[A_SROA_31_0_DST_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[DST]], i64 40
; CHECK-NEXT:    store i16 [[A_SROA_6_SROA_0_0_COPYLOAD]], ptr [[A_SROA_31_0_DST_SROA_IDX]], align 1, !tbaa [[TBAA7]]
; CHECK-NEXT:    [[A_SROA_31_SROA_4_0_A_SROA_31_0_DST_SROA_IDX_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_31_0_DST_SROA_IDX]], i64 2
; CHECK-NEXT:    store i8 [[A_SROA_6_SROA_3_0_COPYLOAD]], ptr [[A_SROA_31_SROA_4_0_A_SROA_31_0_DST_SROA_IDX_SROA_IDX]], align 1, !tbaa [[TBAA7]]
; CHECK-NEXT:    [[A_SROA_31_SROA_5_0_A_SROA_31_0_DST_SROA_IDX_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_31_0_DST_SROA_IDX]], i64 3
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_31_SROA_5_0_A_SROA_31_0_DST_SROA_IDX_SROA_IDX]], ptr align 1 [[A_SROA_31_SROA_5]], i32 7, i1 false), !tbaa [[TBAA7]]
; CHECK-NEXT:    [[A_SROA_6_0_DST_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[DST]], i64 50
; CHECK-NEXT:    store i16 [[A_SROA_6_SROA_0_0_COPYLOAD]], ptr [[A_SROA_6_0_DST_SROA_IDX]], align 1, !tbaa [[TBAA7]]
; CHECK-NEXT:    [[A_SROA_6_SROA_3_0_A_SROA_6_0_DST_SROA_IDX_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_6_0_DST_SROA_IDX]], i64 2
; CHECK-NEXT:    store i8 [[A_SROA_6_SROA_3_0_COPYLOAD]], ptr [[A_SROA_6_SROA_3_0_A_SROA_6_0_DST_SROA_IDX_SROA_IDX]], align 1, !tbaa [[TBAA7]]
; CHECK-NEXT:    [[A_SROA_6_SROA_4_0_A_SROA_6_0_DST_SROA_IDX_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A_SROA_6_0_DST_SROA_IDX]], i64 3
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_6_SROA_4_0_A_SROA_6_0_DST_SROA_IDX_SROA_IDX]], ptr align 1 [[A_SROA_6_SROA_4]], i32 7, i1 false), !tbaa [[TBAA7]]
; CHECK-NEXT:    [[A_SROA_7_0_DST_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[DST]], i64 60
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_7_0_DST_SROA_IDX]], ptr align 1 [[A_SROA_7]], i32 40, i1 false), !tbaa [[TBAA7]]
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca [100 x i8]

  call void @llvm.memcpy.p0.p0.i32(ptr %a, ptr %src, i32 100, i1 false), !tbaa !0

  %a.src.1 = getelementptr [100 x i8], ptr %a, i64 0, i64 20
  %a.dst.1 = getelementptr [100 x i8], ptr %a, i64 0, i64 40
  call void @llvm.memcpy.p0.p0.i32(ptr %a.dst.1, ptr %a.src.1, i32 10, i1 false), !tbaa !3

  ; Clobber a single element of the array, this should be promotable, and be deleted.
  %c = getelementptr [100 x i8], ptr %a, i64 0, i64 42
  store i8 0, ptr %c

  %a.src.2 = getelementptr [100 x i8], ptr %a, i64 0, i64 50
  call void @llvm.memmove.p0.p0.i32(ptr %a.dst.1, ptr %a.src.2, i32 10, i1 false), !tbaa !5

  call void @llvm.memcpy.p0.p0.i32(ptr %dst, ptr %a, i32 100, i1 false), !tbaa !7

  ret void
}

declare void @llvm.memcpy.p0.p0.i32(ptr nocapture, ptr nocapture, i32, i1) nounwind
declare void @llvm.memcpy.p1.p0.i32(ptr addrspace(1) nocapture, ptr nocapture, i32, i1) nounwind
declare void @llvm.memmove.p0.p0.i32(ptr nocapture, ptr nocapture, i32, i1) nounwind
declare void @llvm.memset.p0.i32(ptr nocapture, i8, i32, i1) nounwind

define i16 @test5() {
; CHECK-LABEL: @test5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast float 0.000000e+00 to i32
; CHECK-NEXT:    [[A_SROA_0_2_EXTRACT_SHIFT:%.*]] = lshr i32 [[TMP0]], 16
; CHECK-NEXT:    [[A_SROA_0_2_EXTRACT_TRUNC:%.*]] = trunc i32 [[A_SROA_0_2_EXTRACT_SHIFT]] to i16
; CHECK-NEXT:    ret i16 [[A_SROA_0_2_EXTRACT_TRUNC]]
;
entry:
  %a = alloca [4 x i8]
  store float 0.0, ptr %a
  %ptr = getelementptr [4 x i8], ptr %a, i32 0, i32 2
  %val = load i16, ptr %ptr
  ret i16 %val
}

define i16 @test5_multi_addrspace_access() {
; CHECK-LABEL: @test5_multi_addrspace_access(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast float 0.000000e+00 to i32
; CHECK-NEXT:    [[A_SROA_0_2_EXTRACT_SHIFT:%.*]] = lshr i32 [[TMP0]], 16
; CHECK-NEXT:    [[A_SROA_0_2_EXTRACT_TRUNC:%.*]] = trunc i32 [[A_SROA_0_2_EXTRACT_SHIFT]] to i16
; CHECK-NEXT:    ret i16 [[A_SROA_0_2_EXTRACT_TRUNC]]
;
entry:
  %a = alloca [4 x i8]
  %fptr.as1 = addrspacecast ptr %a to ptr addrspace(1)
  store float 0.0, ptr addrspace(1) %fptr.as1
  %ptr = getelementptr [4 x i8], ptr %a, i32 0, i32 2
  %val = load i16, ptr %ptr
  ret i16 %val
}

define i32 @test6() {
; CHECK-LABEL: @test6(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SROA_0:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store volatile i32 707406378, ptr [[A_SROA_0]], align 4
; CHECK-NEXT:    [[A_SROA_0_0_A_SROA_0_0_VAL:%.*]] = load i32, ptr [[A_SROA_0]], align 4
; CHECK-NEXT:    ret i32 [[A_SROA_0_0_A_SROA_0_0_VAL]]
;
entry:
  %a = alloca [4 x i8]
  call void @llvm.memset.p0.i32(ptr %a, i8 42, i32 4, i1 true)
  %val = load i32, ptr %a
  ret i32 %val
}

define void @test7(ptr %src, ptr %dst) {
; CHECK-LABEL: @test7(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SROA_0:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[A_SROA_0_0_COPYLOAD:%.*]] = load volatile i32, ptr [[SRC:%.*]], align 1, !tbaa [[TBAA0]]
; CHECK-NEXT:    store volatile i32 [[A_SROA_0_0_COPYLOAD]], ptr [[A_SROA_0]], align 4, !tbaa [[TBAA0]]
; CHECK-NEXT:    [[A_SROA_0_0_A_SROA_0_0_COPYLOAD1:%.*]] = load volatile i32, ptr [[A_SROA_0]], align 4, !tbaa [[TBAA3]]
; CHECK-NEXT:    store volatile i32 [[A_SROA_0_0_A_SROA_0_0_COPYLOAD1]], ptr [[DST:%.*]], align 1, !tbaa [[TBAA3]]
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca [4 x i8]
  call void @llvm.memcpy.p0.p0.i32(ptr %a, ptr %src, i32 4, i1 true), !tbaa !0
  call void @llvm.memcpy.p0.p0.i32(ptr %dst, ptr %a, i32 4, i1 true), !tbaa !3
  ret void
}


%S1 = type { i32, i32, [16 x i8] }
%S2 = type { ptr, ptr }

define %S2 @test8(ptr %arg) {
; CHECK-LABEL: @test8(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[S2_NEXT_PTR:%.*]] = getelementptr [[S2:%.*]], ptr [[ARG:%.*]], i64 0, i32 1
; CHECK-NEXT:    [[S2_NEXT:%.*]] = load ptr, ptr [[S2_NEXT_PTR]], align 8, !tbaa [[TBAA0]]
; CHECK-NEXT:    [[S2_NEXT_S1:%.*]] = load ptr, ptr [[S2_NEXT]], align 8, !tbaa [[TBAA3]]
; CHECK-NEXT:    [[S2_NEXT_NEXT_PTR:%.*]] = getelementptr [[S2]], ptr [[S2_NEXT]], i64 0, i32 1
; CHECK-NEXT:    [[S2_NEXT_NEXT:%.*]] = load ptr, ptr [[S2_NEXT_NEXT_PTR]], align 8, !tbaa [[TBAA7]]
; CHECK-NEXT:    [[RESULT1:%.*]] = insertvalue [[S2]] poison, ptr [[S2_NEXT_S1]], 0
; CHECK-NEXT:    [[RESULT2:%.*]] = insertvalue [[S2]] [[RESULT1]], ptr [[S2_NEXT_NEXT]], 1
; CHECK-NEXT:    ret [[S2]] [[RESULT2]]
;
entry:
  %new = alloca %S2

  %s2.next.ptr = getelementptr %S2, ptr %arg, i64 0, i32 1
  %s2.next = load ptr, ptr %s2.next.ptr, !tbaa !0

  %s2.next.s1 = load ptr, ptr %s2.next, !tbaa !3
  store ptr %s2.next.s1, ptr %new, !tbaa !5
  %s2.next.next.ptr = getelementptr %S2, ptr %s2.next, i64 0, i32 1
  %s2.next.next = load ptr, ptr %s2.next.next.ptr, !tbaa !7
  %new.next.ptr = getelementptr %S2, ptr %new, i64 0, i32 1
  store ptr %s2.next.next, ptr %new.next.ptr, !tbaa !9

  %new.s1 = load ptr, ptr %new
  %result1 = insertvalue %S2 poison, ptr %new.s1, 0
  %new.next = load ptr, ptr %new.next.ptr
  %result2 = insertvalue %S2 %result1, ptr %new.next, 1
  ret %S2 %result2
}

define i64 @test9() {
; Ensure we can handle loads off the end of an alloca even when wrapped in
; weird bit casts and types. This is valid IR due to the alignment and masking
; off the bits past the end of the alloca.
;
;
; CHECK-LABEL: @test9(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SROA_3_0_INSERT_EXT:%.*]] = zext i8 26 to i64
; CHECK-NEXT:    [[A_SROA_3_0_INSERT_SHIFT:%.*]] = shl i64 [[A_SROA_3_0_INSERT_EXT]], 16
; CHECK-NEXT:    [[A_SROA_3_0_INSERT_MASK:%.*]] = and i64 undef, -16711681
; CHECK-NEXT:    [[A_SROA_3_0_INSERT_INSERT:%.*]] = or i64 [[A_SROA_3_0_INSERT_MASK]], [[A_SROA_3_0_INSERT_SHIFT]]
; CHECK-NEXT:    [[A_SROA_2_0_INSERT_EXT:%.*]] = zext i8 0 to i64
; CHECK-NEXT:    [[A_SROA_2_0_INSERT_SHIFT:%.*]] = shl i64 [[A_SROA_2_0_INSERT_EXT]], 8
; CHECK-NEXT:    [[A_SROA_2_0_INSERT_MASK:%.*]] = and i64 [[A_SROA_3_0_INSERT_INSERT]], -65281
; CHECK-NEXT:    [[A_SROA_2_0_INSERT_INSERT:%.*]] = or i64 [[A_SROA_2_0_INSERT_MASK]], [[A_SROA_2_0_INSERT_SHIFT]]
; CHECK-NEXT:    [[A_SROA_0_0_INSERT_EXT:%.*]] = zext i8 0 to i64
; CHECK-NEXT:    [[A_SROA_0_0_INSERT_MASK:%.*]] = and i64 [[A_SROA_2_0_INSERT_INSERT]], -256
; CHECK-NEXT:    [[A_SROA_0_0_INSERT_INSERT:%.*]] = or i64 [[A_SROA_0_0_INSERT_MASK]], [[A_SROA_0_0_INSERT_EXT]]
; CHECK-NEXT:    [[RESULT:%.*]] = and i64 [[A_SROA_0_0_INSERT_INSERT]], 16777215
; CHECK-NEXT:    ret i64 [[RESULT]]
;
entry:
  %a = alloca { [3 x i8] }, align 8
  store i8 0, ptr %a, align 1
  %gep2 = getelementptr inbounds { [3 x i8] }, ptr %a, i32 0, i32 0, i32 1
  store i8 0, ptr %gep2, align 1
  %gep3 = getelementptr inbounds { [3 x i8] }, ptr %a, i32 0, i32 0, i32 2
  store i8 26, ptr %gep3, align 1
  %load = load i64, ptr %a
  %result = and i64 %load, 16777215
  ret i64 %result
}

define ptr @test10() {
; CHECK-LABEL: @test10(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = ptrtoint ptr null to i64
; CHECK-NEXT:    ret ptr null
;
entry:
  %a = alloca [8 x i8]
  call void @llvm.memset.p0.i32(ptr %a, i8 0, i32 8, i1 false)
  %s2ptr = load ptr, ptr %a
  ret ptr %s2ptr
}

define i32 @test11(i1 %c1) {
; CHECK-LABEL: @test11(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C1:%.*]], label [[GOOD:%.*]], label [[BAD:%.*]]
; CHECK:       good:
; CHECK-NEXT:    ret i32 0
; CHECK:       bad:
; CHECK-NEXT:    ret i32 poison
;
entry:
  %X = alloca i32
  br i1 %c1, label %good, label %bad

good:
  store i32 0, ptr %X
  %Z = load i32, ptr %X
  ret i32 %Z

bad:
  %Y2 = getelementptr i32, ptr %X, i64 1
  store i32 0, ptr %Y2
  %Z2 = load i32, ptr %Y2
  ret i32 %Z2
}

define i8 @test12() {
; We fully promote these to the i24 load or store size, resulting in just masks
; and other operations that instcombine will fold, but no alloca.
;
;
; CHECK-LABEL: @test12(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SROA_3_0_INSERT_EXT:%.*]] = zext i8 0 to i24
; CHECK-NEXT:    [[A_SROA_3_0_INSERT_SHIFT:%.*]] = shl i24 [[A_SROA_3_0_INSERT_EXT]], 16
; CHECK-NEXT:    [[A_SROA_3_0_INSERT_MASK:%.*]] = and i24 undef, 65535
; CHECK-NEXT:    [[A_SROA_3_0_INSERT_INSERT:%.*]] = or i24 [[A_SROA_3_0_INSERT_MASK]], [[A_SROA_3_0_INSERT_SHIFT]]
; CHECK-NEXT:    [[A_SROA_2_0_INSERT_EXT:%.*]] = zext i8 0 to i24
; CHECK-NEXT:    [[A_SROA_2_0_INSERT_SHIFT:%.*]] = shl i24 [[A_SROA_2_0_INSERT_EXT]], 8
; CHECK-NEXT:    [[A_SROA_2_0_INSERT_MASK:%.*]] = and i24 [[A_SROA_3_0_INSERT_INSERT]], -65281
; CHECK-NEXT:    [[A_SROA_2_0_INSERT_INSERT:%.*]] = or i24 [[A_SROA_2_0_INSERT_MASK]], [[A_SROA_2_0_INSERT_SHIFT]]
; CHECK-NEXT:    [[A_SROA_0_0_INSERT_EXT:%.*]] = zext i8 0 to i24
; CHECK-NEXT:    [[A_SROA_0_0_INSERT_MASK:%.*]] = and i24 [[A_SROA_2_0_INSERT_INSERT]], -256
; CHECK-NEXT:    [[A_SROA_0_0_INSERT_INSERT:%.*]] = or i24 [[A_SROA_0_0_INSERT_MASK]], [[A_SROA_0_0_INSERT_EXT]]
; CHECK-NEXT:    [[B_SROA_0_0_EXTRACT_TRUNC:%.*]] = trunc i24 [[A_SROA_0_0_INSERT_INSERT]] to i8
; CHECK-NEXT:    [[B_SROA_2_0_EXTRACT_SHIFT:%.*]] = lshr i24 [[A_SROA_0_0_INSERT_INSERT]], 8
; CHECK-NEXT:    [[B_SROA_2_0_EXTRACT_TRUNC:%.*]] = trunc i24 [[B_SROA_2_0_EXTRACT_SHIFT]] to i8
; CHECK-NEXT:    [[B_SROA_3_0_EXTRACT_SHIFT:%.*]] = lshr i24 [[A_SROA_0_0_INSERT_INSERT]], 16
; CHECK-NEXT:    [[B_SROA_3_0_EXTRACT_TRUNC:%.*]] = trunc i24 [[B_SROA_3_0_EXTRACT_SHIFT]] to i8
; CHECK-NEXT:    [[BSUM0:%.*]] = add i8 [[B_SROA_0_0_EXTRACT_TRUNC]], [[B_SROA_2_0_EXTRACT_TRUNC]]
; CHECK-NEXT:    [[BSUM1:%.*]] = add i8 [[BSUM0]], [[B_SROA_3_0_EXTRACT_TRUNC]]
; CHECK-NEXT:    ret i8 [[BSUM1]]
;
entry:
  %a = alloca [3 x i8]
  %b = alloca [3 x i8]

  store i8 0, ptr %a
  %a1ptr = getelementptr [3 x i8], ptr %a, i64 0, i32 1
  store i8 0, ptr %a1ptr
  %a2ptr = getelementptr [3 x i8], ptr %a, i64 0, i32 2
  store i8 0, ptr %a2ptr
  %ai = load i24, ptr %a

  store i24 %ai, ptr %b
  %b0 = load i8, ptr %b
  %b1ptr = getelementptr [3 x i8], ptr %b, i64 0, i32 1
  %b1 = load i8, ptr %b1ptr
  %b2ptr = getelementptr [3 x i8], ptr %b, i64 0, i32 2
  %b2 = load i8, ptr %b2ptr

  %bsum0 = add i8 %b0, %b1
  %bsum1 = add i8 %bsum0, %b2
  ret i8 %bsum1
}

define i32 @test13() {
; Ensure we don't crash and handle undefined loads that straddle the end of the
; allocation.
;
; CHECK-LABEL: @test13(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SROA_2_2_LOAD_EXT:%.*]] = zext i8 0 to i16
; CHECK-NEXT:    [[RET:%.*]] = zext i16 [[A_SROA_2_2_LOAD_EXT]] to i32
; CHECK-NEXT:    ret i32 [[RET]]
;
entry:
  %a = alloca [3 x i8], align 2
  store i8 0, ptr %a
  %b1ptr = getelementptr [3 x i8], ptr %a, i64 0, i32 1
  store i8 0, ptr %b1ptr
  %b2ptr = getelementptr [3 x i8], ptr %a, i64 0, i32 2
  store i8 0, ptr %b2ptr
  %iptrgep = getelementptr i16, ptr %a, i64 1
  %i = load i16, ptr %iptrgep
  %ret = zext i16 %i to i32
  ret i32 %ret
}

%test14.struct = type { [3 x i32] }

define void @test14(...) nounwind uwtable {
; This is a strange case where we split allocas into promotable partitions, but
; also gain enough data to prove they must be dead allocas due to GEPs that walk
; across two adjacent allocas. Test that we don't try to promote or otherwise
; do bad things to these dead allocas, they should just be removed.
;
; CHECK-LABEL: @test14(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca %test14.struct
  %p = alloca ptr
  %0 = getelementptr i8, ptr %a, i64 12
  %1 = load i32, ptr %a, align 4
  store i32 %1, ptr %0, align 4
  %2 = getelementptr inbounds i32, ptr %0, i32 1
  %3 = getelementptr inbounds i32, ptr %a, i32 1
  %4 = load i32, ptr %3, align 4
  store i32 %4, ptr %2, align 4
  %5 = getelementptr inbounds i32, ptr %0, i32 2
  %6 = getelementptr inbounds i32, ptr %a, i32 2
  %7 = load i32, ptr %6, align 4
  store i32 %7, ptr %5, align 4
  ret void
}

define i32 @test15(i1 %flag) nounwind uwtable {
; Ensure that when there are dead instructions using an alloca that are not
; loads or stores we still delete them during partitioning and rewriting.
; Otherwise we'll go to promote them while thy still have unpromotable uses.
;
; CHECK-LABEL: @test15(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    br label [[LOOP]]
;
entry:
  %l0 = alloca i64
  %l1 = alloca i64
  %l2 = alloca i64
  %l3 = alloca i64
  br label %loop

loop:
  %dead3 = phi ptr [ %gep3, %loop ], [ null, %entry ]

  store i64 1879048192, ptr %l0, align 8
  %gep0 = getelementptr i8, ptr %l0, i64 3

  store i64 1879048192, ptr %l1, align 8
  %gep1 = getelementptr i8, ptr %l1, i64 3
  %dead1 = getelementptr i8, ptr %gep1, i64 1

  store i64 1879048192, ptr %l2, align 8
  %gep2.1 = getelementptr i8, ptr %l2, i64 1
  %gep2.2 = getelementptr i8, ptr %l2, i64 3
  ; Note that this select should get visited multiple times due to using two
  ; different GEPs off the same alloca. We should only delete it once.
  %dead2 = select i1 %flag, ptr %gep2.1, ptr %gep2.2

  store i64 1879048192, ptr %l3, align 8
  %gep3 = getelementptr i8, ptr %l3, i64 3

  br label %loop
}

define void @test16(ptr %src, ptr %dst) {
; Ensure that we can promote an alloca of [3 x i8] to an i24 SSA value.
;
; CHECK-LABEL: @test16(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SROA_0_0_COPYLOAD:%.*]] = load i24, ptr [[SRC:%.*]], align 1, !tbaa [[TBAA0]]
; CHECK-NEXT:    store i24 0, ptr [[DST:%.*]], align 1, !tbaa [[TBAA5]]
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca [3 x i8]
  call void @llvm.memcpy.p0.p0.i32(ptr %a, ptr %src, i32 4, i1 false), !tbaa !0
  store i24 0, ptr %a, !tbaa !3
  call void @llvm.memcpy.p0.p0.i32(ptr %dst, ptr %a, i32 4, i1 false), !tbaa !5
  ret void
}

define void @test17(ptr %src, ptr %dst) {
; Ensure that we can rewrite unpromotable memcpys which extend past the end of
; the alloca.
;
; CHECK-LABEL: @test17(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca [3 x i8], align 1
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr [[A]], ptr [[SRC:%.*]], i32 4, i1 true), !tbaa [[TBAA0]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr [[DST:%.*]], ptr [[A]], i32 4, i1 true), !tbaa [[TBAA3]]
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca [3 x i8]
  call void @llvm.memcpy.p0.p0.i32(ptr %a, ptr %src, i32 4, i1 true), !tbaa !0
  call void @llvm.memcpy.p0.p0.i32(ptr %dst, ptr %a, i32 4, i1 true), !tbaa !3
  ret void
}

define void @test18(ptr %src, ptr %dst, i32 %size) {
; Preserve transfer intrinsics with a variable size, even if they overlap with
; fixed size operations. Further, continue to split and promote allocas preceding
; the variable sized intrinsic.
;
; CHECK-LABEL: @test18(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SROA_33:%.*]] = alloca [34 x i8], align 1
; CHECK-NEXT:    [[A_SROA_0_0_COPYLOAD:%.*]] = load i32, ptr [[SRC:%.*]], align 1, !tbaa [[TBAA0]]
; CHECK-NEXT:    [[A_SROA_3_0_SRC_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[SRC]], i64 4
; CHECK-NEXT:    [[A_SROA_3_0_COPYLOAD:%.*]] = load i32, ptr [[A_SROA_3_0_SRC_SROA_IDX]], align 1, !tbaa [[TBAA0]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A_SROA_33]], ptr [[SRC]], i32 [[SIZE:%.*]], i1 false), !tbaa [[TBAA3]]
; CHECK-NEXT:    call void @llvm.memset.p0.i32(ptr align 1 [[A_SROA_33]], i8 42, i32 [[SIZE]], i1 false), !tbaa [[TBAA5]]
; CHECK-NEXT:    store i32 42, ptr [[DST:%.*]], align 1, !tbaa [[TBAA9]]
; CHECK-NEXT:    [[A_SROA_3_0_DST_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[DST]], i64 4
; CHECK-NEXT:    store i32 [[A_SROA_3_0_COPYLOAD]], ptr [[A_SROA_3_0_DST_SROA_IDX]], align 1, !tbaa [[TBAA9]]
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr [[DST]], ptr align 1 [[A_SROA_33]], i32 [[SIZE]], i1 false), !tbaa [[TBAA11]]
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca [42 x i8]
  call void @llvm.memcpy.p0.p0.i32(ptr %a, ptr %src, i32 8, i1 false), !tbaa !0
  %ptr2 = getelementptr [42 x i8], ptr %a, i32 0, i32 8
  call void @llvm.memcpy.p0.p0.i32(ptr %ptr2, ptr %src, i32 %size, i1 false), !tbaa !3
  call void @llvm.memset.p0.i32(ptr %ptr2, i8 42, i32 %size, i1 false), !tbaa !5
  store i32 42, ptr %a, !tbaa !7
  call void @llvm.memcpy.p0.p0.i32(ptr %dst, ptr %a, i32 8, i1 false), !tbaa !9
  call void @llvm.memcpy.p0.p0.i32(ptr %dst, ptr %ptr2, i32 %size, i1 false), !tbaa !11
  ret void
}

%opaque = type opaque

define i64 @test19(ptr %x) {
; This input will cause us to try to compute a natural GEP when rewriting
; pointers in such a way that we try to GEP through the opaque type. Previously,
; a check for an unsized type was missing and this crashed. Ensure it behaves
; reasonably now.
;
; CHECK-LABEL: @test19(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SROA_0_0_COPYLOAD:%.*]] = load i64, ptr [[X:%.*]], align 1
; CHECK-NEXT:    [[A_SROA_2_0_X_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[X]], i64 8
; CHECK-NEXT:    [[A_SROA_2_0_COPYLOAD:%.*]] = load ptr, ptr [[A_SROA_2_0_X_SROA_IDX]], align 1
; CHECK-NEXT:    ret i64 [[A_SROA_0_0_COPYLOAD]]
;
entry:
  %a = alloca { i64, ptr }
  call void @llvm.memcpy.p0.p0.i32(ptr %a, ptr %x, i32 16, i1 false)
  %gep = getelementptr inbounds { i64, ptr }, ptr %a, i32 0, i32 0
  %val = load i64, ptr %gep
  ret i64 %val
}

declare void @llvm.memcpy.p0.p1.i32(ptr nocapture, ptr addrspace(1) nocapture, i32, i32, i1) nounwind

define i64 @test19_addrspacecast(ptr %x) {
; This input will cause us to try to compute a natural GEP when rewriting
; pointers in such a way that we try to GEP through the opaque type. Previously,
; a check for an unsized type was missing and this crashed. Ensure it behaves
; reasonably now.
;
; CHECK-LABEL: @test19_addrspacecast(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CAST1:%.*]] = addrspacecast ptr [[X:%.*]] to ptr addrspace(1)
; CHECK-NEXT:    [[A_SROA_0_0_COPYLOAD:%.*]] = load i64, ptr addrspace(1) [[CAST1]], align 1
; CHECK-NEXT:    [[A_SROA_2_0_CAST1_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr addrspace(1) [[CAST1]], i16 8
; CHECK-NEXT:    [[A_SROA_2_0_COPYLOAD:%.*]] = load ptr, ptr addrspace(1) [[A_SROA_2_0_CAST1_SROA_IDX]], align 1
; CHECK-NEXT:    ret i64 [[A_SROA_0_0_COPYLOAD]]
;
entry:
  %a = alloca { i64, ptr }
  %cast1 = addrspacecast ptr %x to ptr addrspace(1)
  call void @llvm.memcpy.p0.p1.i32(ptr %a, ptr addrspace(1) %cast1, i32 16, i32 1, i1 false)
  %gep = getelementptr inbounds { i64, ptr }, ptr %a, i32 0, i32 0
  %val = load i64, ptr %gep
  ret i64 %val
}

define i32 @test20() {
; Ensure we can track negative offsets (before the beginning of the alloca) and
; negative relative offsets from offsets starting past the end of the alloca.
;
; CHECK-LABEL: @test20(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SUM1:%.*]] = add i32 1, 2
; CHECK-NEXT:    [[SUM2:%.*]] = add i32 [[SUM1]], 3
; CHECK-NEXT:    ret i32 [[SUM2]]
;
entry:
  %a = alloca [3 x i32]
  store i32 1, ptr %a
  %gep2.1 = getelementptr [3 x i32], ptr %a, i32 0, i32 -2
  %gep2.2 = getelementptr i32, ptr %gep2.1, i32 3
  store i32 2, ptr %gep2.2
  %gep3.1 = getelementptr [3 x i32], ptr %a, i32 0, i32 14
  %gep3.2 = getelementptr i32, ptr %gep3.1, i32 -12
  store i32 3, ptr %gep3.2

  %load1 = load i32, ptr %a
  %load2 = load i32, ptr %gep2.2
  %load3 = load i32, ptr %gep3.2
  %sum1 = add i32 %load1, %load2
  %sum2 = add i32 %sum1, %load3
  ret i32 %sum2
}

declare void @llvm.memset.p0.i64(ptr nocapture, i8, i64, i1) nounwind

define i8 @test21() {
; Test allocations and offsets which border on overflow of the int64_t used
; internally. This is really awkward to really test as LLVM doesn't really
; support such extreme constructs cleanly.
;
; CHECK-LABEL: @test21(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[RESULT:%.*]] = or i8 -1, -1
; CHECK-NEXT:    ret i8 [[RESULT]]
;
entry:
  %a = alloca [2305843009213693951 x i8]
  %gep0 = getelementptr [2305843009213693951 x i8], ptr %a, i64 0, i64 2305843009213693949
  store i8 255, ptr %gep0
  %gep1 = getelementptr [2305843009213693951 x i8], ptr %a, i64 0, i64 -9223372036854775807
  %gep2 = getelementptr i8, ptr %gep1, i64 -1
  call void @llvm.memset.p0.i64(ptr %gep2, i8 0, i64 18446744073709551615, i1 false)
  %gep3 = getelementptr i8, ptr %gep1, i64 9223372036854775807
  %gep4 = getelementptr i8, ptr %gep3, i64 9223372036854775807
  %gep5 = getelementptr i8, ptr %gep4, i64 -6917529027641081857
  store i8 255, ptr %gep5
  store i32 0, ptr %gep4
  %load = load i8, ptr %gep0
  %gep6 = getelementptr i8, ptr %gep0, i32 1
  %load2 = load i8, ptr %gep6
  %result = or i8 %load, %load2
  ret i8 %result
}

%PR13916.struct = type { i8 }

define void @PR13916.1() {
; Ensure that we handle overlapping memcpy intrinsics correctly, especially in
; the case where there is a directly identical value for both source and dest.
;
; CHECK-LABEL: @PR13916.1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca i8
  call void @llvm.memcpy.p0.p0.i32(ptr %a, ptr %a, i32 1, i1 false)
  %tmp2 = load i8, ptr %a
  ret void
}

define void @PR13916.2(i1 %c1) {
; Check whether we continue to handle them correctly when they start off with
; different pointer value chains, but during rewriting we coalesce them into the
; same value.
;
; CHECK-LABEL: @PR13916.2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C1:%.*]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca %PR13916.struct, align 1
  br i1 %c1, label %if.then, label %if.end

if.then:
  call void @llvm.memcpy.p0.p0.i32(ptr %a, ptr %a, i32 1, i1 false)
  br label %if.end

if.end:
  %tmp2 = load i8, ptr %a
  ret void
}

define void @PR13990(i1 %c1, i1 %c2, i1 %c3, i1 %c4, ptr %ptr) {
; Ensure we can handle cases where processing one alloca causes the other
; alloca to become dead and get deleted. This might crash or fail under
; Valgrind if we regress.
;
; CHECK-LABEL: @PR13990(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C1:%.*]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    br i1 [[C2:%.*]], label [[BB2]], label [[BB3:%.*]]
; CHECK:       bb2:
; CHECK-NEXT:    br i1 [[C4:%.*]], label [[BB3]], label [[BB4:%.*]]
; CHECK:       bb3:
; CHECK-NEXT:    unreachable
; CHECK:       bb4:
; CHECK-NEXT:    unreachable
;
entry:
  %tmp1 = alloca ptr
  %tmp2 = alloca ptr
  br i1 %c1, label %bb1, label %bb2

bb1:
  store ptr %ptr, ptr %tmp2
  br i1 %c2, label %bb2, label %bb3

bb2:
  %tmp50 = select i1 %c3, ptr %tmp2, ptr %tmp1
  br i1 %c4, label %bb3, label %bb4

bb3:
  unreachable

bb4:
  unreachable
}

define double @PR13969(double %x) {
; Check that we detect when promotion will un-escape an alloca and iterate to
; re-try running SROA over that alloca. Without that, the two allocas that are
; stored into a dead alloca don't get rewritten and promoted.
;
; CHECK-LABEL: @PR13969(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret double [[X:%.*]]
;
entry:
  %a = alloca double
  %b = alloca ptr
  %c = alloca double

  store double %x, ptr %a
  store ptr %c, ptr %b
  store ptr %a, ptr %b
  store double %x, ptr %c
  %ret = load double, ptr %a

  ret double %ret
}

%PR14034.struct = type { { {} }, i32, %PR14034.list }
%PR14034.list = type { ptr, ptr }

define void @PR14034(ptr %ptr, ptr %ptr2) {
; This test case tries to form GEPs into the empty leading struct members, and
; subsequently crashed (under valgrind) before we fixed the PR. The important
; thing is to handle empty structs gracefully.
;
; CHECK-LABEL: @PR14034(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SROA_0:%.*]] = alloca [12 x i8], align 8
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[PTR2:%.*]], ptr align 8 [[A_SROA_0]], i32 12, i1 false)
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca %PR14034.struct
  %list = getelementptr %PR14034.struct, ptr %a, i32 0, i32 2
  %prev = getelementptr %PR14034.list, ptr %list, i32 0, i32 1
  store ptr %ptr, ptr %prev
  call void @llvm.memcpy.p0.p0.i32(ptr %ptr2, ptr %a, i32 12, i1 false)
  ret void
}

define i32 @test22(i32 %x) {
; Test that SROA and promotion is not confused by a grab bax mixture of pointer
; types involving wrapper aggregates and zero-length aggregate members.
;
; CHECK-LABEL: @test22(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[WRAP1:%.*]] = insertvalue [1 x { i32 }] poison, i32 [[X:%.*]], 0, 0
; CHECK-NEXT:    [[WRAP1_FCA_0_0_EXTRACT:%.*]] = extractvalue [1 x { i32 }] [[WRAP1]], 0, 0
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast i32 [[WRAP1_FCA_0_0_EXTRACT]] to float
; CHECK-NEXT:    [[LOAD1_FCA_0_0_0_INSERT:%.*]] = insertvalue { [1 x { float }] } poison, float [[TMP0]], 0, 0, 0
; CHECK-NEXT:    [[UNWRAP1:%.*]] = extractvalue { [1 x { float }] } [[LOAD1_FCA_0_0_0_INSERT]], 0, 0
; CHECK-NEXT:    [[WRAP2:%.*]] = insertvalue { {}, { float }, [0 x i8] } poison, { float } [[UNWRAP1]], 1
; CHECK-NEXT:    [[WRAP2_FCA_1_0_EXTRACT:%.*]] = extractvalue { {}, { float }, [0 x i8] } [[WRAP2]], 1, 0
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast float [[WRAP2_FCA_1_0_EXTRACT]] to <4 x i8>
; CHECK-NEXT:    [[VALCAST1:%.*]] = bitcast <4 x i8> [[TMP1]] to i32
; CHECK-NEXT:    [[WRAP3:%.*]] = insertvalue [1 x [1 x i32]] poison, i32 [[VALCAST1]], 0, 0
; CHECK-NEXT:    [[WRAP4:%.*]] = insertvalue { [1 x [1 x i32]], {} } poison, [1 x [1 x i32]] [[WRAP3]], 0
; CHECK-NEXT:    [[WRAP4_FCA_0_0_0_EXTRACT:%.*]] = extractvalue { [1 x [1 x i32]], {} } [[WRAP4]], 0, 0, 0
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast i32 [[WRAP4_FCA_0_0_0_EXTRACT]] to <4 x i8>
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <4 x i8> [[TMP2]] to float
; CHECK-NEXT:    [[LOAD4_FCA_1_INSERT:%.*]] = insertvalue { {}, float, {} } poison, float [[TMP3]], 1
; CHECK-NEXT:    [[UNWRAP2:%.*]] = extractvalue { {}, float, {} } [[LOAD4_FCA_1_INSERT]], 1
; CHECK-NEXT:    [[VALCAST2:%.*]] = bitcast float [[UNWRAP2]] to i32
; CHECK-NEXT:    ret i32 [[VALCAST2]]
;
entry:
  %a1 = alloca { { [1 x { i32 }] } }
  %a2 = alloca { {}, { float }, [0 x i8] }
  %a3 = alloca { [0 x i8], { [0 x double], [1 x [1 x <4 x i8>]], {} }, { { {} } } }

  %wrap1 = insertvalue [1 x { i32 }] poison, i32 %x, 0, 0
  store [1 x { i32 }] %wrap1, ptr %a1

  %load1 = load { [1 x { float }] }, ptr %a1
  %unwrap1 = extractvalue { [1 x { float }] } %load1, 0, 0

  %wrap2 = insertvalue { {}, { float }, [0 x i8] } poison, { float } %unwrap1, 1
  store { {}, { float }, [0 x i8] } %wrap2, ptr %a2

  %gep3 = getelementptr { {}, { float }, [0 x i8] }, ptr %a2, i32 0, i32 1, i32 0
  %load3 = load <4 x i8>, ptr %gep3
  %valcast1 = bitcast <4 x i8> %load3 to i32

  %wrap3 = insertvalue [1 x [1 x i32]] poison, i32 %valcast1, 0, 0
  %wrap4 = insertvalue { [1 x [1 x i32]], {} } poison, [1 x [1 x i32]] %wrap3, 0
  %gep4 = getelementptr { [0 x i8], { [0 x double], [1 x [1 x <4 x i8>]], {} }, { { {} } } }, ptr %a3, i32 0, i32 1
  store { [1 x [1 x i32]], {} } %wrap4, ptr %gep4

  %gep5 = getelementptr { [0 x i8], { [0 x double], [1 x [1 x <4 x i8>]], {} }, { { {} } } }, ptr %a3, i32 0, i32 1, i32 1, i32 0
  %load4 = load { {}, float, {} }, ptr %gep5
  %unwrap2 = extractvalue { {}, float, {} } %load4, 1
  %valcast2 = bitcast float %unwrap2 to i32

  ret i32 %valcast2
}

define void @PR14059.1(ptr %d) {
; In PR14059 a peculiar construct was identified as something that is used
; pervasively in ARM's ABI-calling-convention lowering: the passing of a struct
; of doubles via an array of i32 in order to place the data into integer
; registers. This in turn was missed as an optimization by SROA due to the
; partial loads and stores of integers to the double alloca we were trying to
; form and promote. The solution is to widen the integer operations to be
; whole-alloca operations, and perform the appropriate bitcasting on the
; *values* rather than the pointers. When this works, partial reads and writes
; via integers can be promoted away.
;
; CHECK-LABEL: @PR14059.1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast double undef to i64
; CHECK-NEXT:    [[X_SROA_0_I_0_INSERT_MASK:%.*]] = and i64 [[TMP0]], -4294967296
; CHECK-NEXT:    [[X_SROA_0_I_0_INSERT_INSERT:%.*]] = or i64 [[X_SROA_0_I_0_INSERT_MASK]], 0
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast i64 [[X_SROA_0_I_0_INSERT_INSERT]] to double
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast double [[TMP1]] to i64
; CHECK-NEXT:    [[X_SROA_0_I_2_INSERT_MASK:%.*]] = and i64 [[TMP2]], -281474976645121
; CHECK-NEXT:    [[X_SROA_0_I_2_INSERT_INSERT:%.*]] = or i64 [[X_SROA_0_I_2_INSERT_MASK]], 0
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast i64 [[X_SROA_0_I_2_INSERT_INSERT]] to double
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast double [[TMP3]] to i64
; CHECK-NEXT:    [[X_SROA_0_I_4_COPYLOAD:%.*]] = load i32, ptr [[D:%.*]], align 1
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast double 0.000000e+00 to i64
; CHECK-NEXT:    [[X_SROA_0_I_4_INSERT_EXT:%.*]] = zext i32 [[X_SROA_0_I_4_COPYLOAD]] to i64
; CHECK-NEXT:    [[X_SROA_0_I_4_INSERT_SHIFT:%.*]] = shl i64 [[X_SROA_0_I_4_INSERT_EXT]], 32
; CHECK-NEXT:    [[X_SROA_0_I_4_INSERT_MASK3:%.*]] = and i64 [[TMP5]], 4294967295
; CHECK-NEXT:    [[X_SROA_0_I_4_INSERT_INSERT4:%.*]] = or i64 [[X_SROA_0_I_4_INSERT_MASK3]], [[X_SROA_0_I_4_INSERT_SHIFT]]
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast i64 [[X_SROA_0_I_4_INSERT_INSERT4]] to double
; CHECK-NEXT:    [[TMP7:%.*]] = bitcast double [[TMP6]] to i64
; CHECK-NEXT:    [[X_SROA_0_I_4_INSERT_MASK:%.*]] = and i64 [[TMP7]], 4294967295
; CHECK-NEXT:    [[X_SROA_0_I_4_INSERT_INSERT:%.*]] = or i64 [[X_SROA_0_I_4_INSERT_MASK]], 4607182418800017408
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast i64 [[X_SROA_0_I_4_INSERT_INSERT]] to double
; CHECK-NEXT:    [[ACCUM_REAL_I:%.*]] = load double, ptr [[D]], align 8
; CHECK-NEXT:    [[ADD_R_I:%.*]] = fadd double [[ACCUM_REAL_I]], [[TMP8]]
; CHECK-NEXT:    store double [[ADD_R_I]], ptr [[D]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %X.sroa.0.i = alloca double, align 8
  call void @llvm.lifetime.start.p0(i64 -1, ptr %X.sroa.0.i)

  ; Store to the low 32-bits...
  store i32 0, ptr %X.sroa.0.i, align 8

  ; Also use a memset to the middle 32-bits for fun.
  %X.sroa.0.2.raw_idx2.i = getelementptr inbounds i8, ptr %X.sroa.0.i, i32 2
  call void @llvm.memset.p0.i64(ptr %X.sroa.0.2.raw_idx2.i, i8 0, i64 4, i1 false)

  ; Or a memset of the whole thing.
  call void @llvm.memset.p0.i64(ptr %X.sroa.0.i, i8 0, i64 8, i1 false)

  ; Write to the high 32-bits with a memcpy.
  %X.sroa.0.4.raw_idx4.i = getelementptr inbounds i8, ptr %X.sroa.0.i, i32 4
  call void @llvm.memcpy.p0.p0.i32(ptr %X.sroa.0.4.raw_idx4.i, ptr %d, i32 4, i1 false)

  ; Store to the high 32-bits...
  store i32 1072693248, ptr %X.sroa.0.4.raw_idx4.i, align 4

  ; Do the actual math...
  %X.sroa.0.0.load1.i = load double, ptr %X.sroa.0.i, align 8
  %accum.real.i = load double, ptr %d, align 8
  %add.r.i = fadd double %accum.real.i, %X.sroa.0.0.load1.i
  store double %add.r.i, ptr %d, align 8
  call void @llvm.lifetime.end.p0(i64 -1, ptr %X.sroa.0.i)
  ret void
}

define i64 @PR14059.2(ptr %phi) {
; Check that SROA can split up alloca-wide integer loads and stores where the
; underlying alloca has smaller components that are accessed independently. This
; shows up particularly with ABI lowering patterns coming out of Clang that rely
; on the particular register placement of a single large integer return value.
;
; CHECK-LABEL: @PR14059.2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[PHI_REALP:%.*]] = getelementptr inbounds { float, float }, ptr [[PHI:%.*]], i32 0, i32 0
; CHECK-NEXT:    [[PHI_REAL:%.*]] = load float, ptr [[PHI_REALP]], align 4
; CHECK-NEXT:    [[PHI_IMAGP:%.*]] = getelementptr inbounds { float, float }, ptr [[PHI]], i32 0, i32 1
; CHECK-NEXT:    [[PHI_IMAG:%.*]] = load float, ptr [[PHI_IMAGP]], align 4
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast float [[PHI_REAL]] to i32
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast float [[PHI_IMAG]] to i32
; CHECK-NEXT:    [[RETVAL_SROA_3_0_INSERT_EXT:%.*]] = zext i32 [[TMP1]] to i64
; CHECK-NEXT:    [[RETVAL_SROA_3_0_INSERT_SHIFT:%.*]] = shl i64 [[RETVAL_SROA_3_0_INSERT_EXT]], 32
; CHECK-NEXT:    [[RETVAL_SROA_3_0_INSERT_MASK:%.*]] = and i64 undef, 4294967295
; CHECK-NEXT:    [[RETVAL_SROA_3_0_INSERT_INSERT:%.*]] = or i64 [[RETVAL_SROA_3_0_INSERT_MASK]], [[RETVAL_SROA_3_0_INSERT_SHIFT]]
; CHECK-NEXT:    [[RETVAL_SROA_0_0_INSERT_EXT:%.*]] = zext i32 [[TMP0]] to i64
; CHECK-NEXT:    [[RETVAL_SROA_0_0_INSERT_MASK:%.*]] = and i64 [[RETVAL_SROA_3_0_INSERT_INSERT]], -4294967296
; CHECK-NEXT:    [[RETVAL_SROA_0_0_INSERT_INSERT:%.*]] = or i64 [[RETVAL_SROA_0_0_INSERT_MASK]], [[RETVAL_SROA_0_0_INSERT_EXT]]
; CHECK-NEXT:    ret i64 [[RETVAL_SROA_0_0_INSERT_INSERT]]
;
entry:
  %retval = alloca { float, float }, align 4

  store i64 0, ptr %retval

  %phi.realp = getelementptr inbounds { float, float }, ptr %phi, i32 0, i32 0
  %phi.real = load float, ptr %phi.realp
  %phi.imagp = getelementptr inbounds { float, float }, ptr %phi, i32 0, i32 1
  %phi.imag = load float, ptr %phi.imagp

  %real = getelementptr inbounds { float, float }, ptr %retval, i32 0, i32 0
  %imag = getelementptr inbounds { float, float }, ptr %retval, i32 0, i32 1
  store float %phi.real, ptr %real
  store float %phi.imag, ptr %imag

  %0 = load i64, ptr %retval, align 1
  ret i64 %0
}

define void @PR14105(ptr %ptr) {
; Ensure that when rewriting the GEP index '-1' for this alloca we preserve is
; sign as negative. We use a volatile memcpy to ensure promotion never actually
; occurs.
;
; CHECK-LABEL: @PR14105(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SROA_0:%.*]] = alloca [16 x i8], align 8
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds { [16 x i8] }, ptr [[PTR:%.*]], i64 -1
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 8 [[GEP]], ptr align 8 [[A_SROA_0]], i32 16, i1 true)
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca { [16 x i8] }, align 8

  %gep = getelementptr inbounds { [16 x i8] }, ptr %ptr, i64 -1

  call void @llvm.memcpy.p0.p0.i32(ptr align 8 %gep, ptr align 8 %a, i32 16, i1 true)
  ret void
}

define void @PR14105_as1(ptr addrspace(1) %ptr) {
; Make sure this the right address space pointer is used for type check.
;
; CHECK-LABEL: @PR14105_as1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SROA_0:%.*]] = alloca [16 x i8], align 8
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds { [16 x i8] }, ptr addrspace(1) [[PTR:%.*]], i64 -1
; CHECK-NEXT:    call void @llvm.memcpy.p1.p0.i32(ptr addrspace(1) align 8 [[GEP]], ptr align 8 [[A_SROA_0]], i32 16, i1 true)
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca { [16 x i8] }, align 8
  %gep = getelementptr inbounds { [16 x i8] }, ptr addrspace(1) %ptr, i64 -1
  call void @llvm.memcpy.p1.p0.i32(ptr addrspace(1) align 8 %gep, ptr align 8 %a, i32 16, i1 true)
  ret void
}

define void @PR14465() {
; Ensure that we don't crash when analyzing a alloca larger than the maximum
; integer type width (MAX_INT_BITS) supported by llvm (1048576*32 > (1<<23)-1).
;
; CHECK-LABEL: @PR14465(
; CHECK-NEXT:    [[STACK:%.*]] = alloca [1048576 x i32], align 16
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 16 [[STACK]], i8 -2, i64 4194304, i1 false)
; CHECK-NEXT:    ret void
;
  %stack = alloca [1048576 x i32], align 16
  call void @llvm.memset.p0.i64(ptr align 16 %stack, i8 -2, i64 4194304, i1 false)
  ret void
}

define void @PR14548(i1 %x) {
; Handle a mixture of i1 and i8 loads and stores to allocas. This particular
; pattern caused crashes and invalid output in the PR, and its nature will
; trigger a mixture in several permutations as we resolve each alloca
; iteratively.
; Note that we don't do a particularly good *job* of handling these mixtures,
; but the hope is that this is very rare.
;
; CHECK-LABEL: @PR14548(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SROA_0:%.*]] = alloca i8, align 8
; CHECK-NEXT:    [[B_SROA_0:%.*]] = alloca i8, align 8
; CHECK-NEXT:    store i1 [[X:%.*]], ptr [[B_SROA_0]], align 8
; CHECK-NEXT:    [[B_SROA_0_0_B_SROA_0_0_FOO:%.*]] = load i8, ptr [[B_SROA_0]], align 8
; CHECK-NEXT:    [[B_SROA_0_0_B_SROA_0_0_COPYLOAD:%.*]] = load i8, ptr [[B_SROA_0]], align 8
; CHECK-NEXT:    store i8 [[B_SROA_0_0_B_SROA_0_0_COPYLOAD]], ptr [[A_SROA_0]], align 8
; CHECK-NEXT:    [[A_SROA_0_0_A_SROA_0_0_BAR:%.*]] = load i8, ptr [[A_SROA_0]], align 8
; CHECK-NEXT:    [[A_SROA_0_0_A_SROA_0_0_BAZ:%.*]] = load i1, ptr [[A_SROA_0]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca <{ i1 }>, align 8
  %b = alloca <{ i1 }>, align 8

  store i1 %x, ptr %b, align 8
  %foo = load i8, ptr %b, align 1

  call void @llvm.memcpy.p0.p0.i32(ptr %a, ptr %b, i32 1, i1 false) nounwind
  %bar = load i8, ptr %a, align 1
  %baz = load i1, ptr %a, align 1

  ret void
}

define <3 x i8> @PR14572.1(i32 %x) {
; Ensure that a split integer store which is wider than the type size of the
; alloca (relying on the alloc size padding) doesn't trigger an assert.
;
; CHECK-LABEL: @PR14572.1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_0_EXTRACT_TRUNC:%.*]] = trunc i32 [[X:%.*]] to i24
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast i24 [[A_0_EXTRACT_TRUNC]] to <3 x i8>
; CHECK-NEXT:    [[A_SROA_2_0_EXTRACT_SHIFT:%.*]] = lshr i32 [[X]], 24
; CHECK-NEXT:    [[A_SROA_2_0_EXTRACT_TRUNC:%.*]] = trunc i32 [[A_SROA_2_0_EXTRACT_SHIFT]] to i8
; CHECK-NEXT:    ret <3 x i8> [[TMP0]]
;
entry:
  %a = alloca <3 x i8>, align 4

  store i32 %x, ptr %a, align 1
  %y = load <3 x i8>, ptr %a, align 4
  ret <3 x i8> %y
}

define i32 @PR14572.2(<3 x i8> %x) {
; Ensure that a split integer load which is wider than the type size of the
; alloca (relying on the alloc size padding) doesn't trigger an assert.
;
; CHECK-LABEL: @PR14572.2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast <3 x i8> [[X:%.*]] to i24
; CHECK-NEXT:    [[A_SROA_2_0_INSERT_EXT:%.*]] = zext i8 undef to i32
; CHECK-NEXT:    [[A_SROA_2_0_INSERT_SHIFT:%.*]] = shl i32 [[A_SROA_2_0_INSERT_EXT]], 24
; CHECK-NEXT:    [[A_SROA_2_0_INSERT_MASK:%.*]] = and i32 undef, 16777215
; CHECK-NEXT:    [[A_SROA_2_0_INSERT_INSERT:%.*]] = or i32 [[A_SROA_2_0_INSERT_MASK]], [[A_SROA_2_0_INSERT_SHIFT]]
; CHECK-NEXT:    [[A_0_INSERT_EXT:%.*]] = zext i24 [[TMP0]] to i32
; CHECK-NEXT:    [[A_0_INSERT_MASK:%.*]] = and i32 [[A_SROA_2_0_INSERT_INSERT]], -16777216
; CHECK-NEXT:    [[A_0_INSERT_INSERT:%.*]] = or i32 [[A_0_INSERT_MASK]], [[A_0_INSERT_EXT]]
; CHECK-NEXT:    ret i32 [[A_0_INSERT_INSERT]]
;
entry:
  %a = alloca <3 x i8>, align 4

  store <3 x i8> %x, ptr %a, align 1
  %y = load i32, ptr %a, align 4
  ret i32 %y
}

define i32 @PR14601(i32 %x) {
; Don't try to form a promotable integer alloca when there is a variable length
; memory intrinsic.
;
; CHECK-LABEL: @PR14601(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @llvm.memset.p0.i32(ptr align 4 [[A]], i8 0, i32 [[X:%.*]], i1 false)
; CHECK-NEXT:    [[A_0_V:%.*]] = load i32, ptr [[A]], align 4
; CHECK-NEXT:    ret i32 [[A_0_V]]
;
entry:
  %a = alloca i32

  call void @llvm.memset.p0.i32(ptr %a, i8 0, i32 %x, i1 false)
  %v = load i32, ptr %a
  ret i32 %v
}

define void @PR15674(ptr %data, ptr %src, i32 %size) {
; Arrange (via control flow) to have unmerged stores of a particular width to
; an alloca where we incrementally store from the end of the array toward the
; beginning of the array. Ensure that the final integer store, despite being
; convertable to the integer type that we end up promoting this alloca toward,
; doesn't get widened to a full alloca store.
;
; CHECK-LABEL: @PR15674(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP_SROA_0:%.*]] = alloca i32, align 4
; CHECK-NEXT:    switch i32 [[SIZE:%.*]], label [[END:%.*]] [
; CHECK-NEXT:    i32 4, label [[BB4:%.*]]
; CHECK-NEXT:    i32 3, label [[BB3:%.*]]
; CHECK-NEXT:    i32 2, label [[BB2:%.*]]
; CHECK-NEXT:    i32 1, label [[BB1:%.*]]
; CHECK-NEXT:    ]
; CHECK:       bb4:
; CHECK-NEXT:    [[SRC_GEP3:%.*]] = getelementptr inbounds i8, ptr [[SRC:%.*]], i32 3
; CHECK-NEXT:    [[SRC_3:%.*]] = load i8, ptr [[SRC_GEP3]], align 1
; CHECK-NEXT:    [[TMP_SROA_0_3_TMP_GEP3_SROA_IDX3:%.*]] = getelementptr inbounds i8, ptr [[TMP_SROA_0]], i64 3
; CHECK-NEXT:    store i8 [[SRC_3]], ptr [[TMP_SROA_0_3_TMP_GEP3_SROA_IDX3]], align 1
; CHECK-NEXT:    br label [[BB3]]
; CHECK:       bb3:
; CHECK-NEXT:    [[SRC_GEP2:%.*]] = getelementptr inbounds i8, ptr [[SRC]], i32 2
; CHECK-NEXT:    [[SRC_2:%.*]] = load i8, ptr [[SRC_GEP2]], align 1
; CHECK-NEXT:    [[TMP_SROA_0_2_TMP_GEP2_SROA_IDX2:%.*]] = getelementptr inbounds i8, ptr [[TMP_SROA_0]], i64 2
; CHECK-NEXT:    store i8 [[SRC_2]], ptr [[TMP_SROA_0_2_TMP_GEP2_SROA_IDX2]], align 2
; CHECK-NEXT:    br label [[BB2]]
; CHECK:       bb2:
; CHECK-NEXT:    [[SRC_GEP1:%.*]] = getelementptr inbounds i8, ptr [[SRC]], i32 1
; CHECK-NEXT:    [[SRC_1:%.*]] = load i8, ptr [[SRC_GEP1]], align 1
; CHECK-NEXT:    [[TMP_SROA_0_1_TMP_GEP1_SROA_IDX1:%.*]] = getelementptr inbounds i8, ptr [[TMP_SROA_0]], i64 1
; CHECK-NEXT:    store i8 [[SRC_1]], ptr [[TMP_SROA_0_1_TMP_GEP1_SROA_IDX1]], align 1
; CHECK-NEXT:    br label [[BB1]]
; CHECK:       bb1:
; CHECK-NEXT:    [[SRC_0:%.*]] = load i8, ptr [[SRC]], align 1
; CHECK-NEXT:    store i8 [[SRC_0]], ptr [[TMP_SROA_0]], align 4
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr [[DATA:%.*]], ptr align 4 [[TMP_SROA_0]], i32 [[SIZE]], i1 false)
; CHECK-NEXT:    ret void
;
entry:
  %tmp = alloca [4 x i8], align 1

  switch i32 %size, label %end [
  i32 4, label %bb4
  i32 3, label %bb3
  i32 2, label %bb2
  i32 1, label %bb1
  ]

bb4:
  %src.gep3 = getelementptr inbounds i8, ptr %src, i32 3
  %src.3 = load i8, ptr %src.gep3
  %tmp.gep3 = getelementptr inbounds [4 x i8], ptr %tmp, i32 0, i32 3
  store i8 %src.3, ptr %tmp.gep3

  br label %bb3

bb3:
  %src.gep2 = getelementptr inbounds i8, ptr %src, i32 2
  %src.2 = load i8, ptr %src.gep2
  %tmp.gep2 = getelementptr inbounds [4 x i8], ptr %tmp, i32 0, i32 2
  store i8 %src.2, ptr %tmp.gep2

  br label %bb2

bb2:
  %src.gep1 = getelementptr inbounds i8, ptr %src, i32 1
  %src.1 = load i8, ptr %src.gep1
  %tmp.gep1 = getelementptr inbounds [4 x i8], ptr %tmp, i32 0, i32 1
  store i8 %src.1, ptr %tmp.gep1

  br label %bb1

bb1:
  %src.0 = load i8, ptr %src
  store i8 %src.0, ptr %tmp

  br label %end

end:
  call void @llvm.memcpy.p0.p0.i32(ptr %data, ptr %tmp, i32 %size, i1 false)
  ret void
}

define void @PR15805(i1 %a, i1 %b) {
; CHECK-PRESERVE-CFG-LABEL: @PR15805(
; CHECK-PRESERVE-CFG-NEXT:    [[C:%.*]] = alloca i64, align 8
; CHECK-PRESERVE-CFG-NEXT:    [[COND_IN:%.*]] = select i1 [[B:%.*]], ptr [[C]], ptr [[C]]
; CHECK-PRESERVE-CFG-NEXT:    [[COND:%.*]] = load i64, ptr [[COND_IN]], align 8
; CHECK-PRESERVE-CFG-NEXT:    ret void
;
; CHECK-MODIFY-CFG-LABEL: @PR15805(
; CHECK-MODIFY-CFG-NEXT:    br i1 [[B:%.*]], label [[DOTCONT:%.*]], label [[DOTELSE:%.*]]
; CHECK-MODIFY-CFG:       .else:
; CHECK-MODIFY-CFG-NEXT:    br label [[DOTCONT]]
; CHECK-MODIFY-CFG:       .cont:
; CHECK-MODIFY-CFG-NEXT:    [[COND:%.*]] = phi i64 [ undef, [[TMP0:%.*]] ], [ undef, [[DOTELSE]] ]
; CHECK-MODIFY-CFG-NEXT:    ret void
;
  %c = alloca i64, align 8
  %p.0.c = select i1 %a, ptr %c, ptr %c
  %cond.in = select i1 %b, ptr %p.0.c, ptr %c
  %cond = load i64, ptr %cond.in, align 8
  ret void
}

define void @PR15805.1(i1 %a, i1 %b, i1 %c2) {
; Same as the normal PR15805, but rigged to place the use before the def inside
; of looping unreachable code. This helps ensure that we aren't sensitive to the
; order in which the uses of the alloca are visited.
;
;
; CHECK-PRESERVE-CFG-LABEL: @PR15805.1(
; CHECK-PRESERVE-CFG-NEXT:    [[C:%.*]] = alloca i64, align 8
; CHECK-PRESERVE-CFG-NEXT:    br label [[EXIT:%.*]]
; CHECK-PRESERVE-CFG:       loop:
; CHECK-PRESERVE-CFG-NEXT:    [[COND_IN:%.*]] = select i1 [[A:%.*]], ptr [[C]], ptr [[C]]
; CHECK-PRESERVE-CFG-NEXT:    [[COND:%.*]] = load i64, ptr [[COND_IN]], align 8
; CHECK-PRESERVE-CFG-NEXT:    br i1 [[C2:%.*]], label [[LOOP:%.*]], label [[EXIT]]
; CHECK-PRESERVE-CFG:       exit:
; CHECK-PRESERVE-CFG-NEXT:    ret void
;
; CHECK-MODIFY-CFG-LABEL: @PR15805.1(
; CHECK-MODIFY-CFG-NEXT:    br label [[EXIT:%.*]]
; CHECK-MODIFY-CFG:       loop:
; CHECK-MODIFY-CFG-NEXT:    [[C_0_LOAD:%.*]] = load i64, ptr poison, align 8
; CHECK-MODIFY-CFG-NEXT:    br i1 [[A:%.*]], label [[LOOP_CONT:%.*]], label [[LOOP_ELSE:%.*]]
; CHECK-MODIFY-CFG:       loop.else:
; CHECK-MODIFY-CFG-NEXT:    [[C_0_LOAD1:%.*]] = load i64, ptr poison, align 8
; CHECK-MODIFY-CFG-NEXT:    br label [[LOOP_CONT]]
; CHECK-MODIFY-CFG:       loop.cont:
; CHECK-MODIFY-CFG-NEXT:    [[COND:%.*]] = phi i64 [ [[C_0_LOAD]], [[LOOP:%.*]] ], [ [[C_0_LOAD1]], [[LOOP_ELSE]] ]
; CHECK-MODIFY-CFG-NEXT:    br i1 [[C2:%.*]], label [[LOOP]], label [[EXIT]]
; CHECK-MODIFY-CFG:       exit:
; CHECK-MODIFY-CFG-NEXT:    ret void
;
  %c = alloca i64, align 8
  br label %exit

loop:
  %cond.in = select i1 %a, ptr %c, ptr %p.0.c
  %p.0.c = select i1 %b, ptr %c, ptr %c
  %cond = load i64, ptr %cond.in, align 8
  br i1 %c2, label %loop, label %exit

exit:
  ret void
}

define void @PR16651.1(ptr %a) {
; This test case caused a crash due to the volatile memcpy in combination with
; lowering to integer loads and stores of a width other than that of the original
; memcpy.
;
;
; CHECK-LABEL: @PR16651.1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B_SROA_0:%.*]] = alloca i16, align 4
; CHECK-NEXT:    [[B_SROA_1:%.*]] = alloca i8, align 2
; CHECK-NEXT:    [[B_SROA_2:%.*]] = alloca i8, align 1
; CHECK-NEXT:    [[B_SROA_0_0_COPYLOAD:%.*]] = load volatile i16, ptr [[A:%.*]], align 4
; CHECK-NEXT:    store volatile i16 [[B_SROA_0_0_COPYLOAD]], ptr [[B_SROA_0]], align 4
; CHECK-NEXT:    [[B_SROA_1_0_A_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A]], i64 2
; CHECK-NEXT:    [[B_SROA_1_0_COPYLOAD:%.*]] = load volatile i8, ptr [[B_SROA_1_0_A_SROA_IDX]], align 2
; CHECK-NEXT:    store volatile i8 [[B_SROA_1_0_COPYLOAD]], ptr [[B_SROA_1]], align 2
; CHECK-NEXT:    [[B_SROA_2_0_A_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[A]], i64 3
; CHECK-NEXT:    [[B_SROA_2_0_COPYLOAD:%.*]] = load volatile i8, ptr [[B_SROA_2_0_A_SROA_IDX]], align 1
; CHECK-NEXT:    store volatile i8 [[B_SROA_2_0_COPYLOAD]], ptr [[B_SROA_2]], align 1
; CHECK-NEXT:    [[B_SROA_1_0_B_SROA_1_2_:%.*]] = load i8, ptr [[B_SROA_1]], align 2
; CHECK-NEXT:    unreachable
;
entry:
  %b = alloca i32, align 4
  call void @llvm.memcpy.p0.p0.i32(ptr align 4 %b, ptr align 4 %a, i32 4, i1 true)
  %b.gep = getelementptr inbounds i8, ptr %b, i32 2
  load i8, ptr %b.gep, align 2
  unreachable
}

define void @PR16651.2(<2 x float> %val, i1 %c1) {
; This test case caused a crash due to failing to promote given a select that
; can't be speculated. It shouldn't be promoted, but we missed that fact when
; analyzing whether we could form a vector promotion because that code didn't
; bail on select instructions.
;
;
; CHECK-PRESERVE-CFG-LABEL: @PR16651.2(
; CHECK-PRESERVE-CFG-NEXT:  entry:
; CHECK-PRESERVE-CFG-NEXT:    [[TV1_SROA_0:%.*]] = alloca <2 x float>, align 8
; CHECK-PRESERVE-CFG-NEXT:    store <2 x float> [[VAL:%.*]], ptr [[TV1_SROA_0]], align 8
; CHECK-PRESERVE-CFG-NEXT:    [[COND105_IN_I_I:%.*]] = select i1 [[C1:%.*]], ptr null, ptr [[TV1_SROA_0]]
; CHECK-PRESERVE-CFG-NEXT:    [[COND105_I_I:%.*]] = load float, ptr [[COND105_IN_I_I]], align 8
; CHECK-PRESERVE-CFG-NEXT:    ret void
;
; CHECK-MODIFY-CFG-LABEL: @PR16651.2(
; CHECK-MODIFY-CFG-NEXT:  entry:
; CHECK-MODIFY-CFG-NEXT:    [[TV1_SROA_0_0_VEC_EXTRACT:%.*]] = extractelement <2 x float> [[VAL:%.*]], i32 0
; CHECK-MODIFY-CFG-NEXT:    br i1 [[C1:%.*]], label [[ENTRY_THEN:%.*]], label [[ENTRY_CONT:%.*]]
; CHECK-MODIFY-CFG:       entry.then:
; CHECK-MODIFY-CFG-NEXT:    [[COND105_I_I_THEN_VAL:%.*]] = load float, ptr null, align 8
; CHECK-MODIFY-CFG-NEXT:    br label [[ENTRY_CONT]]
; CHECK-MODIFY-CFG:       entry.cont:
; CHECK-MODIFY-CFG-NEXT:    [[COND105_I_I:%.*]] = phi float [ [[COND105_I_I_THEN_VAL]], [[ENTRY_THEN]] ], [ [[TV1_SROA_0_0_VEC_EXTRACT]], [[ENTRY:%.*]] ]
; CHECK-MODIFY-CFG-NEXT:    ret void
;
entry:
  %tv1 = alloca { <2 x float>, <2 x float> }, align 8
  %0 = getelementptr { <2 x float>, <2 x float> }, ptr %tv1, i64 0, i32 1
  store <2 x float> %val, ptr %0, align 8
  %1 = getelementptr inbounds { <2 x float>, <2 x float> }, ptr %tv1, i64 0, i32 1, i64 0
  %cond105.in.i.i = select i1 %c1, ptr null, ptr %1
  %cond105.i.i = load float, ptr %cond105.in.i.i, align 8
  ret void
}

define void @test23(i32 %x) {
; CHECK-LABEL: @test23(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca i32, align 4
  store i32 %x, ptr %a, align 4
  %gep1 = getelementptr inbounds i32, ptr %a, i32 1
  call void @llvm.memcpy.p0.p0.i32(ptr %gep1, ptr %a, i32 4, i1 false)
  ret void
}

define void @PR18615(ptr %ptr) {
; CHECK-LABEL: @PR18615(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret void
;
entry:
  %f = alloca i8
  %gep = getelementptr i8, ptr %f, i64 -1
  call void @llvm.memcpy.p0.p0.i32(ptr %ptr, ptr %gep, i32 1, i1 false)
  ret void
}

define void @test24(ptr %src, ptr %dst) {
; CHECK-LABEL: @test24(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca i64, align 16
; CHECK-NEXT:    [[A_0_COPYLOAD:%.*]] = load volatile i64, ptr [[SRC:%.*]], align 1, !tbaa [[TBAA0]]
; CHECK-NEXT:    store volatile i64 [[A_0_COPYLOAD]], ptr [[A]], align 16, !tbaa [[TBAA0]]
; CHECK-NEXT:    [[A_0_COPYLOAD1:%.*]] = load volatile i64, ptr [[A]], align 16, !tbaa [[TBAA3]]
; CHECK-NEXT:    store volatile i64 [[A_0_COPYLOAD1]], ptr [[DST:%.*]], align 1, !tbaa [[TBAA3]]
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca i64, align 16
  call void @llvm.memcpy.p0.p0.i32(ptr %a, ptr %src, i32 8, i1 true), !tbaa !0
  call void @llvm.memcpy.p0.p0.i32(ptr %dst, ptr %a, i32 8, i1 true), !tbaa !3
  ret void
}

define float @test25() {
; Check that we split up stores in order to promote the smaller SSA values.. These types
; of patterns can arise because LLVM maps small memcpy's to integer load and
; stores. If we get a memcpy of an aggregate (such as C and C++ frontends would
; produce, but so might any language frontend), this will in many cases turn into
; an integer load and store. SROA needs to be extremely powerful to correctly
; handle these cases and form splitable and promotable SSA values.
;
;
; CHECK-LABEL: @test25(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast i32 0 to float
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast i32 1065353216 to float
; CHECK-NEXT:    [[RET:%.*]] = fadd float [[TMP0]], [[TMP1]]
; CHECK-NEXT:    ret float [[RET]]
;
entry:
  %a = alloca i64
  %b = alloca i64
  %a.gep2 = getelementptr [2 x float], ptr %a, i32 0, i32 1
  %b.gep2 = getelementptr [2 x float], ptr %b, i32 0, i32 1
  store float 0.0, ptr %a
  store float 1.0, ptr %a.gep2
  %v = load i64, ptr %a
  store i64 %v, ptr %b
  %f1 = load float, ptr %b
  %f2 = load float, ptr %b.gep2
  %ret = fadd float %f1, %f2
  ret float %ret
}

@complex1 = external global [2 x float]
@complex2 = external global [2 x float]

define void @test26() {
; Test a case of splitting up loads and stores against a globals.
;
;
; CHECK-LABEL: @test26(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[V13:%.*]] = load i32, ptr @complex1, align 4
; CHECK-NEXT:    [[V14:%.*]] = load i32, ptr getelementptr inbounds (i8, ptr @complex1, i64 4), align 4
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast i32 [[V13]] to float
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast i32 [[V14]] to float
; CHECK-NEXT:    [[SUM:%.*]] = fadd float [[TMP0]], [[TMP1]]
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast float [[SUM]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast float [[SUM]] to i32
; CHECK-NEXT:    store i32 [[TMP2]], ptr @complex2, align 4
; CHECK-NEXT:    store i32 [[TMP3]], ptr getelementptr inbounds (i8, ptr @complex2, i64 4), align 4
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca i64
  %a.gep2 = getelementptr [2 x float], ptr %a, i32 0, i32 1
  %v1 = load i64, ptr @complex1
  store i64 %v1, ptr %a
  %f1 = load float, ptr %a
  %f2 = load float, ptr %a.gep2
  %sum = fadd float %f1, %f2
  store float %sum, ptr %a
  store float %sum, ptr %a.gep2
  %v2 = load i64, ptr %a
  store i64 %v2, ptr @complex2
  ret void
}

define float @test27() {
; Another, more complex case of splittable i64 loads and stores. This example
; is a particularly challenging one because the load and store both point into
; the alloca SROA is processing, and they overlap but at an offset.
;
;
; CHECK-LABEL: @test27(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast i32 0 to float
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast i32 1065353216 to float
; CHECK-NEXT:    [[RET:%.*]] = fadd float [[TMP0]], [[TMP1]]
; CHECK-NEXT:    ret float [[RET]]
;
entry:
  %a = alloca [12 x i8]
  %gep2 = getelementptr [12 x i8], ptr %a, i32 0, i32 4
  %gep3 = getelementptr [12 x i8], ptr %a, i32 0, i32 8
  store float 0.0, ptr %a
  store float 1.0, ptr %gep2
  %v = load i64, ptr %a
  store i64 %v, ptr %gep2
  %f1 = load float, ptr %gep2
  %f2 = load float, ptr %gep3
  %ret = fadd float %f1, %f2
  ret float %ret
}

define i32 @PR22093() {
; Test that we don't try to pre-split a splittable store of a splittable but
; not pre-splittable load over the same alloca. We "handle" this case when the
; load is unsplittable but unrelated to this alloca by just generating extra
; loads without touching the original, but when the original load was out of
; this alloca we need to handle it specially to ensure the splits line up
; properly for rewriting.
;
;
; CHECK-LABEL: @PR22093(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SROA_0:%.*]] = alloca i16, align 4
; CHECK-NEXT:    store volatile i16 42, ptr [[A_SROA_0]], align 4
; CHECK-NEXT:    [[A_SROA_0_0_A_SROA_0_0_LOAD:%.*]] = load i16, ptr [[A_SROA_0]], align 4
; CHECK-NEXT:    [[A_SROA_3_0_INSERT_EXT:%.*]] = zext i16 undef to i32
; CHECK-NEXT:    [[A_SROA_3_0_INSERT_SHIFT:%.*]] = shl i32 [[A_SROA_3_0_INSERT_EXT]], 16
; CHECK-NEXT:    [[A_SROA_3_0_INSERT_MASK:%.*]] = and i32 undef, 65535
; CHECK-NEXT:    [[A_SROA_3_0_INSERT_INSERT:%.*]] = or i32 [[A_SROA_3_0_INSERT_MASK]], [[A_SROA_3_0_INSERT_SHIFT]]
; CHECK-NEXT:    [[A_SROA_0_0_INSERT_EXT:%.*]] = zext i16 [[A_SROA_0_0_A_SROA_0_0_LOAD]] to i32
; CHECK-NEXT:    [[A_SROA_0_0_INSERT_MASK:%.*]] = and i32 [[A_SROA_3_0_INSERT_INSERT]], -65536
; CHECK-NEXT:    [[A_SROA_0_0_INSERT_INSERT:%.*]] = or i32 [[A_SROA_0_0_INSERT_MASK]], [[A_SROA_0_0_INSERT_EXT]]
; CHECK-NEXT:    [[A_SROA_0_0_EXTRACT_TRUNC:%.*]] = trunc i32 [[A_SROA_0_0_INSERT_INSERT]] to i16
; CHECK-NEXT:    store i16 [[A_SROA_0_0_EXTRACT_TRUNC]], ptr [[A_SROA_0]], align 4
; CHECK-NEXT:    [[A_SROA_3_0_EXTRACT_SHIFT:%.*]] = lshr i32 [[A_SROA_0_0_INSERT_INSERT]], 16
; CHECK-NEXT:    [[A_SROA_3_0_EXTRACT_TRUNC:%.*]] = trunc i32 [[A_SROA_3_0_EXTRACT_SHIFT]] to i16
; CHECK-NEXT:    ret i32 [[A_SROA_0_0_INSERT_INSERT]]
;
entry:
  %a = alloca i32
  store volatile i16 42, ptr %a
  %load = load i32, ptr %a
  store i32 %load, ptr %a
  ret i32 %load
}

define void @PR22093.2() {
; Another way that we end up being unable to split a particular set of loads
; and stores can even have ordering importance. Here we have a load which is
; pre-splittable by itself, and the first store is also compatible. But the
; second store of the load makes the load unsplittable because of a mismatch of
; splits. Because this makes the load unsplittable, we also have to go back and
; remove the first store from the presplit candidates as its load won't be
; presplit.
;
;
; CHECK-LABEL: @PR22093.2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SROA_0:%.*]] = alloca i16, align 8
; CHECK-NEXT:    [[A_SROA_31:%.*]] = alloca i8, align 4
; CHECK-NEXT:    store volatile i16 42, ptr [[A_SROA_0]], align 8
; CHECK-NEXT:    [[A_SROA_0_0_A_SROA_0_0_LOAD:%.*]] = load i16, ptr [[A_SROA_0]], align 8
; CHECK-NEXT:    [[A_SROA_3_0_INSERT_EXT:%.*]] = zext i16 undef to i32
; CHECK-NEXT:    [[A_SROA_3_0_INSERT_SHIFT:%.*]] = shl i32 [[A_SROA_3_0_INSERT_EXT]], 16
; CHECK-NEXT:    [[A_SROA_3_0_INSERT_MASK:%.*]] = and i32 undef, 65535
; CHECK-NEXT:    [[A_SROA_3_0_INSERT_INSERT:%.*]] = or i32 [[A_SROA_3_0_INSERT_MASK]], [[A_SROA_3_0_INSERT_SHIFT]]
; CHECK-NEXT:    [[A_SROA_0_0_INSERT_EXT:%.*]] = zext i16 [[A_SROA_0_0_A_SROA_0_0_LOAD]] to i32
; CHECK-NEXT:    [[A_SROA_0_0_INSERT_MASK:%.*]] = and i32 [[A_SROA_3_0_INSERT_INSERT]], -65536
; CHECK-NEXT:    [[A_SROA_0_0_INSERT_INSERT:%.*]] = or i32 [[A_SROA_0_0_INSERT_MASK]], [[A_SROA_0_0_INSERT_EXT]]
; CHECK-NEXT:    [[A_SROA_0_0_EXTRACT_TRUNC:%.*]] = trunc i32 [[A_SROA_0_0_INSERT_INSERT]] to i16
; CHECK-NEXT:    store i16 [[A_SROA_0_0_EXTRACT_TRUNC]], ptr [[A_SROA_0]], align 8
; CHECK-NEXT:    [[A_SROA_3_0_EXTRACT_SHIFT:%.*]] = lshr i32 [[A_SROA_0_0_INSERT_INSERT]], 16
; CHECK-NEXT:    [[A_SROA_3_0_EXTRACT_TRUNC:%.*]] = trunc i32 [[A_SROA_3_0_EXTRACT_SHIFT]] to i16
; CHECK-NEXT:    store volatile i8 13, ptr [[A_SROA_31]], align 4
; CHECK-NEXT:    [[A_SROA_31_4_EXTRACT_TRUNC:%.*]] = trunc i32 [[A_SROA_0_0_INSERT_INSERT]] to i8
; CHECK-NEXT:    store i8 [[A_SROA_31_4_EXTRACT_TRUNC]], ptr [[A_SROA_31]], align 4
; CHECK-NEXT:    [[A_SROA_5_4_EXTRACT_SHIFT:%.*]] = lshr i32 [[A_SROA_0_0_INSERT_INSERT]], 8
; CHECK-NEXT:    [[A_SROA_5_4_EXTRACT_TRUNC:%.*]] = trunc i32 [[A_SROA_5_4_EXTRACT_SHIFT]] to i24
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca i64
  store volatile i16 42, ptr %a
  %load = load i32, ptr %a
  store i32 %load, ptr %a
  %a.gep1 = getelementptr i32, ptr %a, i32 1
  store volatile i8 13, ptr %a.gep1
  store i32 %load, ptr %a.gep1
  ret void
}

define void @PR23737() {
; CHECK-LABEL: @PR23737(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[PTR:%.*]] = alloca i64, align 8
; CHECK-NEXT:    store atomic volatile i64 0, ptr [[PTR]] seq_cst, align 8
; CHECK-NEXT:    [[PTR_0_LOAD:%.*]] = load atomic volatile i64, ptr [[PTR]] seq_cst, align 8
; CHECK-NEXT:    ret void
;
entry:
  %ptr = alloca i64, align 8
  store atomic volatile i64 0, ptr %ptr seq_cst, align 8
  %load = load atomic volatile i64, ptr %ptr seq_cst, align 8
  ret void
}

define i16 @PR24463() {
; Ensure we can handle a very interesting case where there is an integer-based
; rewrite of the uses of the alloca, but where one of the integers in that is
; a sub-integer that requires extraction *and* extends past the end of the
; alloca. SROA can split the alloca to avoid shift or trunc.
;
;
; CHECK-LABEL: @PR24463(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ALLOCA_SROA_1_2_LOAD_EXT:%.*]] = zext i8 0 to i16
; CHECK-NEXT:    ret i16 [[ALLOCA_SROA_1_2_LOAD_EXT]]
;
entry:
  %alloca = alloca [3 x i8]
  %gep1 = getelementptr inbounds [3 x i8], ptr %alloca, i64 0, i64 1
  store i16 0, ptr %gep1
  %gep2 = getelementptr inbounds [3 x i8], ptr %alloca, i64 0, i64 2
  %load = load i16, ptr %gep2
  ret i16 %load
}

%struct.STest = type { %struct.SPos, %struct.SPos }
%struct.SPos = type { float, float }

define void @PR25873(ptr %outData) {
; CHECK-LABEL: @PR25873(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store i32 1123418112, ptr [[OUTDATA:%.*]], align 4
; CHECK-NEXT:    [[OUTDATA_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[OUTDATA]], i64 4
; CHECK-NEXT:    store i32 1139015680, ptr [[OUTDATA_SROA_IDX]], align 4
; CHECK-NEXT:    [[TMPDATA_SROA_6_0_OUTDATA_SROA_IDX:%.*]] = getelementptr inbounds i8, ptr [[OUTDATA]], i64 8
; CHECK-NEXT:    [[TMPDATA_SROA_6_SROA_4_0_INSERT_EXT:%.*]] = zext i32 1139015680 to i64
; CHECK-NEXT:    [[TMPDATA_SROA_6_SROA_4_0_INSERT_SHIFT:%.*]] = shl i64 [[TMPDATA_SROA_6_SROA_4_0_INSERT_EXT]], 32
; CHECK-NEXT:    [[TMPDATA_SROA_6_SROA_4_0_INSERT_MASK:%.*]] = and i64 undef, 4294967295
; CHECK-NEXT:    [[TMPDATA_SROA_6_SROA_4_0_INSERT_INSERT:%.*]] = or i64 [[TMPDATA_SROA_6_SROA_4_0_INSERT_MASK]], [[TMPDATA_SROA_6_SROA_4_0_INSERT_SHIFT]]
; CHECK-NEXT:    [[TMPDATA_SROA_6_SROA_0_0_INSERT_EXT:%.*]] = zext i32 1123418112 to i64
; CHECK-NEXT:    [[TMPDATA_SROA_6_SROA_0_0_INSERT_MASK:%.*]] = and i64 [[TMPDATA_SROA_6_SROA_4_0_INSERT_INSERT]], -4294967296
; CHECK-NEXT:    [[TMPDATA_SROA_6_SROA_0_0_INSERT_INSERT:%.*]] = or i64 [[TMPDATA_SROA_6_SROA_0_0_INSERT_MASK]], [[TMPDATA_SROA_6_SROA_0_0_INSERT_EXT]]
; CHECK-NEXT:    store i64 [[TMPDATA_SROA_6_SROA_0_0_INSERT_INSERT]], ptr [[TMPDATA_SROA_6_0_OUTDATA_SROA_IDX]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %tmpData = alloca %struct.STest, align 8
  call void @llvm.lifetime.start.p0(i64 16, ptr %tmpData)
  store float 1.230000e+02, ptr %tmpData, align 8
  %y = getelementptr inbounds %struct.STest, ptr %tmpData, i64 0, i32 0, i32 1
  store float 4.560000e+02, ptr %y, align 4
  %m_posB = getelementptr inbounds %struct.STest, ptr %tmpData, i64 0, i32 1
  %0 = load i64, ptr %tmpData, align 8
  store i64 %0, ptr %m_posB, align 8
  call void @llvm.memcpy.p0.p0.i64(ptr align 4 %outData, ptr align 4 %tmpData, i64 16, i1 false)
  call void @llvm.lifetime.end.p0(i64 16, ptr %tmpData)
  ret void
}

declare void @llvm.memcpy.p0.p0.i64(ptr nocapture, ptr nocapture, i64, i1) nounwind

define void @PR27999() unnamed_addr {
; CHECK-LABEL: @PR27999(
; CHECK-NEXT:  entry-block:
; CHECK-NEXT:    ret void
;
entry-block:
  %0 = alloca [2 x i64], align 8
  call void @llvm.lifetime.start.p0(i64 16, ptr %0)
  %1 = getelementptr inbounds [2 x i64], ptr %0, i32 0, i32 1
  call void @llvm.lifetime.end.p0(i64 8, ptr %1)
  ret void
}

define void @PR29139() {
; CHECK-LABEL: @PR29139(
; CHECK-NEXT:  bb1:
; CHECK-NEXT:    ret void
;
bb1:
  %e.7.sroa.6.i = alloca i32, align 1
  %e.7.sroa.6.0.load81.i = load i32, ptr %e.7.sroa.6.i, align 1
  call void @llvm.lifetime.end.p0(i64 2, ptr %e.7.sroa.6.i)
  ret void
}

; PR35657 reports assertion failure with this code
define void @PR35657(i64 %v) {
; CHECK-LABEL: @PR35657(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A48_SROA_0_0_EXTRACT_TRUNC:%.*]] = trunc i64 [[V:%.*]] to i16
; CHECK-NEXT:    [[A48_SROA_2_0_EXTRACT_SHIFT:%.*]] = lshr i64 [[V]], 16
; CHECK-NEXT:    [[A48_SROA_2_0_EXTRACT_TRUNC:%.*]] = trunc i64 [[A48_SROA_2_0_EXTRACT_SHIFT]] to i48
; CHECK-NEXT:    call void @callee16(i16 [[A48_SROA_0_0_EXTRACT_TRUNC]])
; CHECK-NEXT:    call void @callee48(i48 [[A48_SROA_2_0_EXTRACT_TRUNC]])
; CHECK-NEXT:    ret void
;
entry:
  %a48 = alloca i48
  store i64 %v, ptr %a48
  %b0_15 = load i16, ptr %a48
  %a48_offset2 = getelementptr inbounds i8, ptr %a48, i64 2
  %b16_63 = load i48, ptr %a48_offset2, align 2
  call void @callee16(i16 %b0_15)
  call void @callee48(i48 %b16_63)
  ret void
}

declare void @callee16(i16 %a)
declare void @callee48(i48 %a)

define void @test28(i64 %v) #0 {
; SROA should split the first i64 store to avoid additional and/or instructions
; when storing into i32 fields
;
; CHECK-LABEL: @test28(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[T_SROA_0_8_EXTRACT_TRUNC:%.*]] = trunc i64 [[V:%.*]] to i32
; CHECK-NEXT:    [[T_SROA_2_8_EXTRACT_SHIFT:%.*]] = lshr i64 [[V]], 32
; CHECK-NEXT:    [[T_SROA_2_8_EXTRACT_TRUNC:%.*]] = trunc i64 [[T_SROA_2_8_EXTRACT_SHIFT]] to i32
; CHECK-NEXT:    ret void
;
entry:
  %t = alloca { i64, i32, i32 }

  %b = getelementptr { i64, i32, i32 }, ptr %t, i32 0, i32 1
  store i64 %v, ptr %b

  %0 = load i32, ptr %b
  %c = getelementptr { i64, i32, i32 }, ptr %t, i32 0, i32 2
  store i32 %0, ptr %c
  ret void
}

declare void @llvm.lifetime.start.isVoid.i64.p0(i64, ptr nocapture)
declare void @llvm.lifetime.end.isVoid.i64.p0(i64, ptr nocapture)
@array = dso_local global [10 x float] zeroinitializer, align 4

define void @test29(i32 %num, i32 %tid) {
; CHECK-LABEL: @test29(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP1:%.*]] = icmp sgt i32 [[NUM:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP1]], label [[BB1:%.*]], label [[BB7:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i32 [[TID:%.*]], 0
; CHECK-NEXT:    [[CONV_I:%.*]] = zext i32 [[TID]] to i64
; CHECK-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds [10 x float], ptr @array, i64 0, i64 [[CONV_I]]
; CHECK-NEXT:    br label [[BB2:%.*]]
; CHECK:       bb2:
; CHECK-NEXT:    [[I_02:%.*]] = phi i32 [ [[NUM]], [[BB1]] ], [ [[SUB:%.*]], [[BB5:%.*]] ]
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[BB3:%.*]], label [[BB4:%.*]]
; CHECK:       bb3:
; CHECK-NEXT:    br label [[BB5]]
; CHECK:       bb4:
; CHECK-NEXT:    store i32 undef, ptr [[ARRAYIDX5]], align 4
; CHECK-NEXT:    br label [[BB5]]
; CHECK:       bb5:
; CHECK-NEXT:    [[SUB]] = add i32 [[I_02]], -1
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[SUB]], 0
; CHECK-NEXT:    br i1 [[CMP]], label [[BB2]], label [[BB6:%.*]]
; CHECK:       bb6:
; CHECK-NEXT:    br label [[BB7]]
; CHECK:       bb7:
; CHECK-NEXT:    ret void
;
entry:
  %ra = alloca [10 x float], align 4
  call void @llvm.lifetime.start.isVoid.i64.p0(i64 40, ptr nonnull %ra)

  %cmp1 = icmp sgt i32 %num, 0
  br i1 %cmp1, label %bb1, label %bb7

bb1:
  %tobool = icmp eq i32 %tid, 0
  %conv.i = zext i32 %tid to i64
  %0 = load i32, ptr %ra, align 4
  %arrayidx5 = getelementptr inbounds [10 x float], ptr @array, i64 0, i64 %conv.i
  br label %bb2

bb2:
  %i.02 = phi i32 [ %num, %bb1 ], [ %sub, %bb5 ]
  br i1 %tobool, label %bb3, label %bb4

bb3:
  br label %bb5

bb4:
  store i32 %0, ptr %arrayidx5, align 4
  br label %bb5

bb5:
  %sub = add i32 %i.02, -1
  %cmp = icmp sgt i32 %sub, 0
  br i1 %cmp, label %bb2, label %bb6

bb6:
  br label %bb7

bb7:
  call void @llvm.lifetime.end.isVoid.i64.p0(i64 40, ptr nonnull %ra)
  ret void
}

!0 = !{!1, !1, i64 0, i64 200}
!1 = !{!2, i64 1, !"type_0"}
!2 = !{!"root"}
!3 = !{!4, !4, i64 0, i64 1}
!4 = !{!2, i64 1, !"type_3"}
!5 = !{!6, !6, i64 0, i64 1}
!6 = !{!2, i64 1, !"type_5"}
!7 = !{!8, !8, i64 0, i64 1}
!8 = !{!2, i64 1, !"type_7"}
!9 = !{!10, !10, i64 0, i64 1}
!10 = !{!2, i64 1, !"type_9"}
!11 = !{!12, !12, i64 0, i64 1}
!12 = !{!2, i64 1, !"type_11"}
!13 = !{!14, !14, i64 0, i64 1}
!14 = !{!2, i64 1, !"type_13"}
!15 = !{!16, !16, i64 0, i64 1}
!16 = !{!2, i64 1, !"type_15"}
!17 = !{!18, !18, i64 0, i64 1}
!18 = !{!2, i64 1, !"type_17"}
!19 = !{!20, !20, i64 0, i64 1}
!20 = !{!2, i64 1, !"type_19"}
!21 = !{!22, !22, i64 0, i64 1}
!22 = !{!2, i64 1, !"type_21"}
!23 = !{!24, !24, i64 0, i64 1}
!24 = !{!2, i64 1, !"type_23"}
!25 = !{!26, !26, i64 0, i64 1}
!26 = !{!2, i64 1, !"type_25"}
!27 = !{!28, !28, i64 0, i64 1}
!28 = !{!2, i64 1, !"type_27"}
!29 = !{!30, !30, i64 0, i64 1}
!30 = !{!2, i64 1, !"type_29"}
!31 = !{!32, !32, i64 0, i64 1}
!32 = !{!2, i64 1, !"type_31"}
!33 = !{!34, !34, i64 0, i64 1}
!34 = !{!2, i64 1, !"type_33"}
!35 = !{!36, !36, i64 0, i64 1}
!36 = !{!2, i64 1, !"type_35"}
!37 = !{!38, !38, i64 0, i64 1}
!38 = !{!2, i64 1, !"type_37"}
!39 = !{!40, !40, i64 0, i64 1}
!40 = !{!2, i64 1, !"type_39"}
!41 = !{!42, !42, i64 0, i64 1}
!42 = !{!2, i64 1, !"type_41"}
!43 = !{!44, !44, i64 0, i64 1}
!44 = !{!2, i64 1, !"type_43"}
!45 = !{!46, !46, i64 0, i64 1}
!46 = !{!2, i64 1, !"type_45"}
!47 = !{!48, !48, i64 0, i64 1}
!48 = !{!2, i64 1, !"type_47"}
!49 = !{!50, !50, i64 0, i64 1}
!50 = !{!2, i64 1, !"type_49"}
!51 = !{!52, !52, i64 0, i64 1}
!52 = !{!2, i64 1, !"type_51"}
!53 = !{!54, !54, i64 0, i64 1}
!54 = !{!2, i64 1, !"type_53"}
!55 = !{!56, !56, i64 0, i64 1}
!56 = !{!2, i64 1, !"type_55"}
!57 = !{!58, !58, i64 0, i64 1}
!58 = !{!2, i64 1, !"type_57"}
!59 = !{!60, !60, i64 0, i64 1}
!60 = !{!2, i64 1, !"type_59"}










