// LWG2296 - addressof should be constexpr
// { dg-do run { target c++11 } }

template <typename T>
constexpr inline T *
addressof (T &x) noexcept
{
  return __builtin_addressof (x);
}

int i;
static_assert (__builtin_addressof (i) == &i, "");
static_assert (addressof (i) == &i, "");

constexpr int &j = i;
static_assert (__builtin_addressof (j) == &i, "");
static_assert (addressof (j) == &i, "");

struct S { int s; } s;
static_assert (__builtin_addressof (s) == &s, "");
static_assert (addressof (s) == &s, "