// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

// DO NOT EDIT THIS FILE! IT IS AUTOGENERATED
// To regenerate run the gen script in src/coreclr/tools/Common/JitInterface/ThunkGenerator
// and follow the instructions in docs/project/updating-jitinterface.md

using System;
using System.Runtime.InteropServices;

namespace Internal.JitInterface
{
    unsafe partial class CorInfoImpl
    {
        [UnmanagedCallersOnly]
        static byte _isJitIntrinsic(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* ftn)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.isJitIntrinsic(ftn) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static uint _getMethodAttribs(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* ftn)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getMethodAttribs(ftn);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _setMethodAttribs(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* ftn, CorInfoMethodRuntimeFlags attribs)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.setMethodAttribs(ftn, attribs);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static void _getMethodSig(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* ftn, CORINFO_SIG_INFO* sig, CORINFO_CLASS_STRUCT_* memberParent)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.getMethodSig(ftn, sig, memberParent);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static byte _getMethodInfo(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* ftn, CORINFO_METHOD_INFO* info)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getMethodInfo(ftn, info) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CorInfoInline _canInline(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* callerHnd, CORINFO_METHOD_STRUCT_* calleeHnd, uint* pRestrictions)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.canInline(callerHnd, calleeHnd, ref *pRestrictions);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _reportInliningDecision(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* inlinerHnd, CORINFO_METHOD_STRUCT_* inlineeHnd, CorInfoInline inlineResult, byte* reason)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.reportInliningDecision(inlinerHnd, inlineeHnd, inlineResult, reason);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static byte _canTailCall(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* callerHnd, CORINFO_METHOD_STRUCT_* declaredCalleeHnd, CORINFO_METHOD_STRUCT_* exactCalleeHnd, byte fIsTailPrefix)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.canTailCall(callerHnd, declaredCalleeHnd, exactCalleeHnd, fIsTailPrefix != 0) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _reportTailCallDecision(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* callerHnd, CORINFO_METHOD_STRUCT_* calleeHnd, byte fIsTailPrefix, CorInfoTailCall tailCallResult, byte* reason)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.reportTailCallDecision(callerHnd, calleeHnd, fIsTailPrefix != 0, tailCallResult, reason);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static void _getEHinfo(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* ftn, uint EHnumber, CORINFO_EH_CLAUSE* clause)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.getEHinfo(ftn, EHnumber, ref *clause);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_CLASS_STRUCT_* _getMethodClass(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* method)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getMethodClass(method);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_MODULE_STRUCT_* _getMethodModule(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* method)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getMethodModule(method);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _getMethodVTableOffset(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* method, uint* offsetOfIndirection, uint* offsetAfterIndirection, bool* isRelative)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.getMethodVTableOffset(method, ref *offsetOfIndirection, ref *offsetAfterIndirection, ref *isRelative);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static byte _resolveVirtualMethod(IntPtr thisHandle, IntPtr* ppException, CORINFO_DEVIRTUALIZATION_INFO* info)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.resolveVirtualMethod(info) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_METHOD_STRUCT_* _getUnboxedEntry(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* ftn, bool* requiresInstMethodTableArg)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getUnboxedEntry(ftn, ref *requiresInstMethodTableArg);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_CLASS_STRUCT_* _getDefaultComparerClass(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* elemType)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getDefaultComparerClass(elemType);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_CLASS_STRUCT_* _getDefaultEqualityComparerClass(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* elemType)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getDefaultEqualityComparerClass(elemType);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _expandRawHandleIntrinsic(IntPtr thisHandle, IntPtr* ppException, CORINFO_RESOLVED_TOKEN* pResolvedToken, CORINFO_GENERICHANDLE_RESULT* pResult)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.expandRawHandleIntrinsic(ref *pResolvedToken, ref *pResult);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static CorInfoIntrinsics _getIntrinsicID(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* method, byte* pMustExpand)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getIntrinsicID(method, pMustExpand);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte _isIntrinsicType(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* classHnd)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.isIntrinsicType(classHnd) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CorInfoCallConvExtension _getUnmanagedCallConv(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* method, CORINFO_SIG_INFO* callSiteSig, bool* pSuppressGCTransition)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getUnmanagedCallConv(method, callSiteSig, ref *pSuppressGCTransition);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte _pInvokeMarshalingRequired(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* method, CORINFO_SIG_INFO* callSiteSig)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.pInvokeMarshalingRequired(method, callSiteSig) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte _satisfiesMethodConstraints(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* parent, CORINFO_METHOD_STRUCT_* method)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.satisfiesMethodConstraints(parent, method) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte _isCompatibleDelegate(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* objCls, CORINFO_CLASS_STRUCT_* methodParentCls, CORINFO_METHOD_STRUCT_* method, CORINFO_CLASS_STRUCT_* delegateCls, bool* pfIsOpenDelegate)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.isCompatibleDelegate(objCls, methodParentCls, method, delegateCls, ref *pfIsOpenDelegate) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _methodMustBeLoadedBeforeCodeIsRun(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* method)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.methodMustBeLoadedBeforeCodeIsRun(method);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_METHOD_STRUCT_* _mapMethodDeclToMethodImpl(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* method)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.mapMethodDeclToMethodImpl(method);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _getGSCookie(IntPtr thisHandle, IntPtr* ppException, IntPtr* pCookieVal, IntPtr** ppCookieVal)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.getGSCookie(pCookieVal, ppCookieVal);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static void _setPatchpointInfo(IntPtr thisHandle, IntPtr* ppException, PatchpointInfo* patchpointInfo)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.setPatchpointInfo(patchpointInfo);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static PatchpointInfo* _getOSRInfo(IntPtr thisHandle, IntPtr* ppException, uint* ilOffset)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getOSRInfo(ref *ilOffset);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _resolveToken(IntPtr thisHandle, IntPtr* ppException, CORINFO_RESOLVED_TOKEN* pResolvedToken)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.resolveToken(ref *pResolvedToken);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static byte _tryResolveToken(IntPtr thisHandle, IntPtr* ppException, CORINFO_RESOLVED_TOKEN* pResolvedToken)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.tryResolveToken(ref *pResolvedToken) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _findSig(IntPtr thisHandle, IntPtr* ppException, CORINFO_MODULE_STRUCT_* module, uint sigTOK, CORINFO_CONTEXT_STRUCT* context, CORINFO_SIG_INFO* sig)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.findSig(module, sigTOK, context, sig);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static void _findCallSiteSig(IntPtr thisHandle, IntPtr* ppException, CORINFO_MODULE_STRUCT_* module, uint methTOK, CORINFO_CONTEXT_STRUCT* context, CORINFO_SIG_INFO* sig)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.findCallSiteSig(module, methTOK, context, sig);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_CLASS_STRUCT_* _getTokenTypeAsHandle(IntPtr thisHandle, IntPtr* ppException, CORINFO_RESOLVED_TOKEN* pResolvedToken)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getTokenTypeAsHandle(ref *pResolvedToken);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte _isValidToken(IntPtr thisHandle, IntPtr* ppException, CORINFO_MODULE_STRUCT_* module, uint metaTOK)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.isValidToken(module, metaTOK) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte _isValidStringRef(IntPtr thisHandle, IntPtr* ppException, CORINFO_MODULE_STRUCT_* module, uint metaTOK)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.isValidStringRef(module, metaTOK) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static char* _getStringLiteral(IntPtr thisHandle, IntPtr* ppException, CORINFO_MODULE_STRUCT_* module, uint metaTOK, int* length)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getStringLiteral(module, metaTOK, ref *length);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CorInfoType _asCorInfoType(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.asCorInfoType(cls);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte* _getClassName(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getClassName(cls);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte* _getClassNameFromMetadata(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls, byte** namespaceName)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getClassNameFromMetadata(cls, namespaceName);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_CLASS_STRUCT_* _getTypeInstantiationArgument(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls, uint index)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getTypeInstantiationArgument(cls, index);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static int _appendClassName(IntPtr thisHandle, IntPtr* ppException, char** ppBuf, int* pnBufLen, CORINFO_CLASS_STRUCT_* cls, byte fNamespace, byte fFullInst, byte fAssembly)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.appendClassName(ppBuf, ref *pnBufLen, cls, fNamespace != 0, fFullInst != 0, fAssembly != 0);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte _isValueClass(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.isValueClass(cls) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CorInfoInlineTypeCheck _canInlineTypeCheck(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls, CorInfoInlineTypeCheckSource source)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.canInlineTypeCheck(cls, source);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static uint _getClassAttribs(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getClassAttribs(cls);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte _isStructRequiringStackAllocRetBuf(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.isStructRequiringStackAllocRetBuf(cls) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_MODULE_STRUCT_* _getClassModule(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getClassModule(cls);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_ASSEMBLY_STRUCT_* _getModuleAssembly(IntPtr thisHandle, IntPtr* ppException, CORINFO_MODULE_STRUCT_* mod)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getModuleAssembly(mod);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte* _getAssemblyName(IntPtr thisHandle, IntPtr* ppException, CORINFO_ASSEMBLY_STRUCT_* assem)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getAssemblyName(assem);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void* _LongLifetimeMalloc(IntPtr thisHandle, IntPtr* ppException, UIntPtr sz)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.LongLifetimeMalloc(sz);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _LongLifetimeFree(IntPtr thisHandle, IntPtr* ppException, void* obj)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.LongLifetimeFree(obj);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static UIntPtr _getClassModuleIdForStatics(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls, CORINFO_MODULE_STRUCT_** pModule, void** ppIndirection)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getClassModuleIdForStatics(cls, pModule, ppIndirection);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static uint _getClassSize(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getClassSize(cls);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static uint _getHeapClassSize(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getHeapClassSize(cls);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte _canAllocateOnStack(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.canAllocateOnStack(cls) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static uint _getClassAlignmentRequirement(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls, byte fDoubleAlignHint)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getClassAlignmentRequirement(cls, fDoubleAlignHint != 0);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static uint _getClassGClayout(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls, byte* gcPtrs)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getClassGClayout(cls, gcPtrs);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static uint _getClassNumInstanceFields(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getClassNumInstanceFields(cls);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_FIELD_STRUCT_* _getFieldInClass(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* clsHnd, int num)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getFieldInClass(clsHnd, num);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte _checkMethodModifier(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* hMethod, byte* modifier, byte fOptional)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.checkMethodModifier(hMethod, modifier, fOptional != 0) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CorInfoHelpFunc _getNewHelper(IntPtr thisHandle, IntPtr* ppException, CORINFO_RESOLVED_TOKEN* pResolvedToken, CORINFO_METHOD_STRUCT_* callerHandle, bool* pHasSideEffects)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getNewHelper(ref *pResolvedToken, callerHandle, ref *pHasSideEffects);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CorInfoHelpFunc _getNewArrHelper(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* arrayCls)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getNewArrHelper(arrayCls);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CorInfoHelpFunc _getCastingHelper(IntPtr thisHandle, IntPtr* ppException, CORINFO_RESOLVED_TOKEN* pResolvedToken, byte fThrowing)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getCastingHelper(ref *pResolvedToken, fThrowing != 0);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CorInfoHelpFunc _getSharedCCtorHelper(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* clsHnd)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getSharedCCtorHelper(clsHnd);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_CLASS_STRUCT_* _getTypeForBox(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getTypeForBox(cls);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CorInfoHelpFunc _getBoxHelper(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getBoxHelper(cls);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CorInfoHelpFunc _getUnBoxHelper(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getUnBoxHelper(cls);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte _getReadyToRunHelper(IntPtr thisHandle, IntPtr* ppException, CORINFO_RESOLVED_TOKEN* pResolvedToken, CORINFO_LOOKUP_KIND* pGenericLookupKind, CorInfoHelpFunc id, CORINFO_CONST_LOOKUP* pLookup)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getReadyToRunHelper(ref *pResolvedToken, ref *pGenericLookupKind, id, ref *pLookup) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _getReadyToRunDelegateCtorHelper(IntPtr thisHandle, IntPtr* ppException, CORINFO_RESOLVED_TOKEN* pTargetMethod, CORINFO_CLASS_STRUCT_* delegateType, CORINFO_LOOKUP* pLookup)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.getReadyToRunDelegateCtorHelper(ref *pTargetMethod, delegateType, ref *pLookup);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static byte* _getHelperName(IntPtr thisHandle, IntPtr* ppException, CorInfoHelpFunc helpFunc)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getHelperName(helpFunc);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CorInfoInitClassResult _initClass(IntPtr thisHandle, IntPtr* ppException, CORINFO_FIELD_STRUCT_* field, CORINFO_METHOD_STRUCT_* method, CORINFO_CONTEXT_STRUCT* context)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.initClass(field, method, context);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _classMustBeLoadedBeforeCodeIsRun(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.classMustBeLoadedBeforeCodeIsRun(cls);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_CLASS_STRUCT_* _getBuiltinClass(IntPtr thisHandle, IntPtr* ppException, CorInfoClassId classId)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getBuiltinClass(classId);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CorInfoType _getTypeForPrimitiveValueClass(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getTypeForPrimitiveValueClass(cls);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CorInfoType _getTypeForPrimitiveNumericClass(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getTypeForPrimitiveNumericClass(cls);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte _canCast(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* child, CORINFO_CLASS_STRUCT_* parent)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.canCast(child, parent) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte _areTypesEquivalent(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls1, CORINFO_CLASS_STRUCT_* cls2)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.areTypesEquivalent(cls1, cls2) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static TypeCompareState _compareTypesForCast(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* fromClass, CORINFO_CLASS_STRUCT_* toClass)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.compareTypesForCast(fromClass, toClass);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static TypeCompareState _compareTypesForEquality(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls1, CORINFO_CLASS_STRUCT_* cls2)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.compareTypesForEquality(cls1, cls2);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_CLASS_STRUCT_* _mergeClasses(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls1, CORINFO_CLASS_STRUCT_* cls2)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.mergeClasses(cls1, cls2);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte _isMoreSpecificType(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls1, CORINFO_CLASS_STRUCT_* cls2)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.isMoreSpecificType(cls1, cls2) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_CLASS_STRUCT_* _getParentType(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getParentType(cls);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CorInfoType _getChildType(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* clsHnd, CORINFO_CLASS_STRUCT_** clsRet)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getChildType(clsHnd, clsRet);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte _satisfiesClassConstraints(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.satisfiesClassConstraints(cls) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte _isSDArray(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.isSDArray(cls) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static uint _getArrayRank(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getArrayRank(cls);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void* _getArrayInitializationData(IntPtr thisHandle, IntPtr* ppException, CORINFO_FIELD_STRUCT_* field, uint size)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getArrayInitializationData(field, size);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CorInfoIsAccessAllowedResult _canAccessClass(IntPtr thisHandle, IntPtr* ppException, CORINFO_RESOLVED_TOKEN* pResolvedToken, CORINFO_METHOD_STRUCT_* callerHandle, CORINFO_HELPER_DESC* pAccessHelper)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.canAccessClass(ref *pResolvedToken, callerHandle, ref *pAccessHelper);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte* _getFieldName(IntPtr thisHandle, IntPtr* ppException, CORINFO_FIELD_STRUCT_* ftn, byte** moduleName)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getFieldName(ftn, moduleName);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_CLASS_STRUCT_* _getFieldClass(IntPtr thisHandle, IntPtr* ppException, CORINFO_FIELD_STRUCT_* field)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getFieldClass(field);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CorInfoType _getFieldType(IntPtr thisHandle, IntPtr* ppException, CORINFO_FIELD_STRUCT_* field, CORINFO_CLASS_STRUCT_** structType, CORINFO_CLASS_STRUCT_* memberParent)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getFieldType(field, structType, memberParent);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static uint _getFieldOffset(IntPtr thisHandle, IntPtr* ppException, CORINFO_FIELD_STRUCT_* field)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getFieldOffset(field);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _getFieldInfo(IntPtr thisHandle, IntPtr* ppException, CORINFO_RESOLVED_TOKEN* pResolvedToken, CORINFO_METHOD_STRUCT_* callerHandle, CORINFO_ACCESS_FLAGS flags, CORINFO_FIELD_INFO* pResult)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.getFieldInfo(ref *pResolvedToken, callerHandle, flags, pResult);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static byte _isFieldStatic(IntPtr thisHandle, IntPtr* ppException, CORINFO_FIELD_STRUCT_* fldHnd)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.isFieldStatic(fldHnd) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _getBoundaries(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* ftn, uint* cILOffsets, uint** pILOffsets, BoundaryTypes* implicitBoundaries)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.getBoundaries(ftn, ref *cILOffsets, ref *pILOffsets, implicitBoundaries);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static void _setBoundaries(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* ftn, uint cMap, OffsetMapping* pMap)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.setBoundaries(ftn, cMap, pMap);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static void _getVars(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* ftn, uint* cVars, ILVarInfo** vars, bool* extendOthers)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.getVars(ftn, ref *cVars, vars, ref *extendOthers);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static void _setVars(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* ftn, uint cVars, NativeVarInfo* vars)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.setVars(ftn, cVars, vars);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static void* _allocateArray(IntPtr thisHandle, IntPtr* ppException, UIntPtr cBytes)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.allocateArray(cBytes);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _freeArray(IntPtr thisHandle, IntPtr* ppException, void* array)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.freeArray(array);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_ARG_LIST_STRUCT_* _getArgNext(IntPtr thisHandle, IntPtr* ppException, CORINFO_ARG_LIST_STRUCT_* args)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getArgNext(args);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CorInfoTypeWithMod _getArgType(IntPtr thisHandle, IntPtr* ppException, CORINFO_SIG_INFO* sig, CORINFO_ARG_LIST_STRUCT_* args, CORINFO_CLASS_STRUCT_** vcTypeRet)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getArgType(sig, args, vcTypeRet);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_CLASS_STRUCT_* _getArgClass(IntPtr thisHandle, IntPtr* ppException, CORINFO_SIG_INFO* sig, CORINFO_ARG_LIST_STRUCT_* args)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getArgClass(sig, args);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CorInfoHFAElemType _getHFAType(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* hClass)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getHFAType(hClass);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static HRESULT _GetErrorHRESULT(IntPtr thisHandle, IntPtr* ppException, _EXCEPTION_POINTERS* pExceptionPointers)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.GetErrorHRESULT(pExceptionPointers);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static uint _GetErrorMessage(IntPtr thisHandle, IntPtr* ppException, char* buffer, uint bufferLength)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.GetErrorMessage(buffer, bufferLength);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static int _FilterException(IntPtr thisHandle, IntPtr* ppException, _EXCEPTION_POINTERS* pExceptionPointers)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.FilterException(pExceptionPointers);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _ThrowExceptionForJitResult(IntPtr thisHandle, IntPtr* ppException, HRESULT result)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.ThrowExceptionForJitResult(result);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static void _ThrowExceptionForHelper(IntPtr thisHandle, IntPtr* ppException, CORINFO_HELPER_DESC* throwHelper)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.ThrowExceptionForHelper(ref *throwHelper);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static byte _runWithErrorTrap(IntPtr thisHandle, IntPtr* ppException, void* function, void* parameter)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.runWithErrorTrap(function, parameter) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte _runWithSPMIErrorTrap(IntPtr thisHandle, IntPtr* ppException, void* function, void* parameter)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.runWithSPMIErrorTrap(function, parameter) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _getEEInfo(IntPtr thisHandle, IntPtr* ppException, CORINFO_EE_INFO* pEEInfoOut)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.getEEInfo(ref *pEEInfoOut);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static char* _getJitTimeLogFilename(IntPtr thisHandle, IntPtr* ppException)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getJitTimeLogFilename();
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static mdToken _getMethodDefFromMethod(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* hMethod)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getMethodDefFromMethod(hMethod);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte* _getMethodName(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* ftn, byte** moduleName)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getMethodName(ftn, moduleName);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte* _getMethodNameFromMetadata(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* ftn, byte** className, byte** namespaceName, byte** enclosingClassName)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getMethodNameFromMetadata(ftn, className, namespaceName, enclosingClassName);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static uint _getMethodHash(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* ftn)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getMethodHash(ftn);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static UIntPtr _findNameOfToken(IntPtr thisHandle, IntPtr* ppException, CORINFO_MODULE_STRUCT_* moduleHandle, mdToken token, byte* szFQName, UIntPtr FQNameCapacity)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.findNameOfToken(moduleHandle, token, szFQName, FQNameCapacity);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte _getSystemVAmd64PassStructInRegisterDescriptor(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* structHnd, SYSTEMV_AMD64_CORINFO_STRUCT_REG_PASSING_DESCRIPTOR* structPassInRegDescPtr)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getSystemVAmd64PassStructInRegisterDescriptor(structHnd, structPassInRegDescPtr) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static uint _getThreadTLSIndex(IntPtr thisHandle, IntPtr* ppException, void** ppIndirection)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getThreadTLSIndex(ref *ppIndirection);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void* _getInlinedCallFrameVptr(IntPtr thisHandle, IntPtr* ppException, void** ppIndirection)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getInlinedCallFrameVptr(ref *ppIndirection);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static int* _getAddrOfCaptureThreadGlobal(IntPtr thisHandle, IntPtr* ppException, void** ppIndirection)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getAddrOfCaptureThreadGlobal(ref *ppIndirection);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void* _getHelperFtn(IntPtr thisHandle, IntPtr* ppException, CorInfoHelpFunc ftnNum, void** ppIndirection)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getHelperFtn(ftnNum, ref *ppIndirection);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _getFunctionEntryPoint(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* ftn, CORINFO_CONST_LOOKUP* pResult, CORINFO_ACCESS_FLAGS accessFlags)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.getFunctionEntryPoint(ftn, ref *pResult, accessFlags);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static void _getFunctionFixedEntryPoint(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* ftn, CORINFO_CONST_LOOKUP* pResult)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.getFunctionFixedEntryPoint(ftn, ref *pResult);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static void* _getMethodSync(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* ftn, void** ppIndirection)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getMethodSync(ftn, ref *ppIndirection);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CorInfoHelpFunc _getLazyStringLiteralHelper(IntPtr thisHandle, IntPtr* ppException, CORINFO_MODULE_STRUCT_* handle)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getLazyStringLiteralHelper(handle);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_MODULE_STRUCT_* _embedModuleHandle(IntPtr thisHandle, IntPtr* ppException, CORINFO_MODULE_STRUCT_* handle, void** ppIndirection)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.embedModuleHandle(handle, ref *ppIndirection);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_CLASS_STRUCT_* _embedClassHandle(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* handle, void** ppIndirection)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.embedClassHandle(handle, ref *ppIndirection);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_METHOD_STRUCT_* _embedMethodHandle(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* handle, void** ppIndirection)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.embedMethodHandle(handle, ref *ppIndirection);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_FIELD_STRUCT_* _embedFieldHandle(IntPtr thisHandle, IntPtr* ppException, CORINFO_FIELD_STRUCT_* handle, void** ppIndirection)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.embedFieldHandle(handle, ref *ppIndirection);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _embedGenericHandle(IntPtr thisHandle, IntPtr* ppException, CORINFO_RESOLVED_TOKEN* pResolvedToken, byte fEmbedParent, CORINFO_GENERICHANDLE_RESULT* pResult)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.embedGenericHandle(ref *pResolvedToken, fEmbedParent != 0, ref *pResult);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static void _getLocationOfThisType(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* context, CORINFO_LOOKUP_KIND* pLookupKind)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.getLocationOfThisType(context, ref *pLookupKind);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static void _getAddressOfPInvokeTarget(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* method, CORINFO_CONST_LOOKUP* pLookup)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.getAddressOfPInvokeTarget(method, ref *pLookup);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static void* _GetCookieForPInvokeCalliSig(IntPtr thisHandle, IntPtr* ppException, CORINFO_SIG_INFO* szMetaSig, void** ppIndirection)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.GetCookieForPInvokeCalliSig(szMetaSig, ref *ppIndirection);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte _canGetCookieForPInvokeCalliSig(IntPtr thisHandle, IntPtr* ppException, CORINFO_SIG_INFO* szMetaSig)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.canGetCookieForPInvokeCalliSig(szMetaSig) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_JUST_MY_CODE_HANDLE_* _getJustMyCodeHandle(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* method, CORINFO_JUST_MY_CODE_HANDLE_** ppIndirection)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getJustMyCodeHandle(method, ref *ppIndirection);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _GetProfilingHandle(IntPtr thisHandle, IntPtr* ppException, bool* pbHookFunction, void** pProfilerHandle, bool* pbIndirectedHandles)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.GetProfilingHandle(ref *pbHookFunction, ref *pProfilerHandle, ref *pbIndirectedHandles);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static void _getCallInfo(IntPtr thisHandle, IntPtr* ppException, CORINFO_RESOLVED_TOKEN* pResolvedToken, CORINFO_RESOLVED_TOKEN* pConstrainedResolvedToken, CORINFO_METHOD_STRUCT_* callerHandle, CORINFO_CALLINFO_FLAGS flags, CORINFO_CALL_INFO* pResult)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.getCallInfo(ref *pResolvedToken, pConstrainedResolvedToken, callerHandle, flags, pResult);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static byte _canAccessFamily(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* hCaller, CORINFO_CLASS_STRUCT_* hInstanceType)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.canAccessFamily(hCaller, hInstanceType) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte _isRIDClassDomainID(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.isRIDClassDomainID(cls) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static uint _getClassDomainID(IntPtr thisHandle, IntPtr* ppException, CORINFO_CLASS_STRUCT_* cls, void** ppIndirection)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getClassDomainID(cls, ref *ppIndirection);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void* _getFieldAddress(IntPtr thisHandle, IntPtr* ppException, CORINFO_FIELD_STRUCT_* field, void** ppIndirection)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getFieldAddress(field, ppIndirection);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_CLASS_STRUCT_* _getStaticFieldCurrentClass(IntPtr thisHandle, IntPtr* ppException, CORINFO_FIELD_STRUCT_* field, byte* pIsSpeculative)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getStaticFieldCurrentClass(field, pIsSpeculative);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static IntPtr _getVarArgsHandle(IntPtr thisHandle, IntPtr* ppException, CORINFO_SIG_INFO* pSig, void** ppIndirection)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getVarArgsHandle(pSig, ref *ppIndirection);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte _canGetVarArgsHandle(IntPtr thisHandle, IntPtr* ppException, CORINFO_SIG_INFO* pSig)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.canGetVarArgsHandle(pSig) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static InfoAccessType _constructStringLiteral(IntPtr thisHandle, IntPtr* ppException, CORINFO_MODULE_STRUCT_* module, mdToken metaTok, void** ppValue)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.constructStringLiteral(module, metaTok, ref *ppValue);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static InfoAccessType _emptyStringLiteral(IntPtr thisHandle, IntPtr* ppException, void** ppValue)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.emptyStringLiteral(ref *ppValue);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static uint _getFieldThreadLocalStoreID(IntPtr thisHandle, IntPtr* ppException, CORINFO_FIELD_STRUCT_* field, void** ppIndirection)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getFieldThreadLocalStoreID(field, ref *ppIndirection);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _setOverride(IntPtr thisHandle, IntPtr* ppException, IntPtr pOverride, CORINFO_METHOD_STRUCT_* currentMethod)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.setOverride(pOverride, currentMethod);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static void _addActiveDependency(IntPtr thisHandle, IntPtr* ppException, CORINFO_MODULE_STRUCT_* moduleFrom, CORINFO_MODULE_STRUCT_* moduleTo)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.addActiveDependency(moduleFrom, moduleTo);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static CORINFO_METHOD_STRUCT_* _GetDelegateCtor(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* methHnd, CORINFO_CLASS_STRUCT_* clsHnd, CORINFO_METHOD_STRUCT_* targetMethodHnd, DelegateCtorArgs* pCtorData)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.GetDelegateCtor(methHnd, clsHnd, targetMethodHnd, ref *pCtorData);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _MethodCompileComplete(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* methHnd)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.MethodCompileComplete(methHnd);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static byte _getTailCallHelpers(IntPtr thisHandle, IntPtr* ppException, CORINFO_RESOLVED_TOKEN* callToken, CORINFO_SIG_INFO* sig, CORINFO_GET_TAILCALL_HELPERS_FLAGS flags, CORINFO_TAILCALL_HELPERS* pResult)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getTailCallHelpers(ref *callToken, sig, flags, ref *pResult) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte _convertPInvokeCalliToCall(IntPtr thisHandle, IntPtr* ppException, CORINFO_RESOLVED_TOKEN* pResolvedToken, byte mustConvert)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.convertPInvokeCalliToCall(ref *pResolvedToken, mustConvert != 0) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte _notifyInstructionSetUsage(IntPtr thisHandle, IntPtr* ppException, InstructionSet instructionSet, byte supportEnabled)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.notifyInstructionSetUsage(instructionSet, supportEnabled != 0) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _allocMem(IntPtr thisHandle, IntPtr* ppException, AllocMemArgs* pArgs)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.allocMem(ref *pArgs);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static void _reserveUnwindInfo(IntPtr thisHandle, IntPtr* ppException, byte isFunclet, byte isColdCode, uint unwindSize)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.reserveUnwindInfo(isFunclet != 0, isColdCode != 0, unwindSize);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static void _allocUnwindInfo(IntPtr thisHandle, IntPtr* ppException, byte* pHotCode, byte* pColdCode, uint startOffset, uint endOffset, uint unwindSize, byte* pUnwindBlock, CorJitFuncKind funcKind)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.allocUnwindInfo(pHotCode, pColdCode, startOffset, endOffset, unwindSize, pUnwindBlock, funcKind);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static void* _allocGCInfo(IntPtr thisHandle, IntPtr* ppException, UIntPtr size)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.allocGCInfo(size);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _setEHcount(IntPtr thisHandle, IntPtr* ppException, uint cEH)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.setEHcount(cEH);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static void _setEHinfo(IntPtr thisHandle, IntPtr* ppException, uint EHnumber, CORINFO_EH_CLAUSE* clause)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.setEHinfo(EHnumber, ref *clause);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static byte _logMsg(IntPtr thisHandle, IntPtr* ppException, uint level, byte* fmt, IntPtr args)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.logMsg(level, fmt, args) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static int _doAssert(IntPtr thisHandle, IntPtr* ppException, byte* szFile, int iLine, byte* szExpr)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.doAssert(szFile, iLine, szExpr);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _reportFatalError(IntPtr thisHandle, IntPtr* ppException, CorJitResult result)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.reportFatalError(result);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static HRESULT _getPgoInstrumentationResults(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* ftnHnd, PgoInstrumentationSchema** pSchema, uint* pCountSchemaItems, byte** pInstrumentationData, PgoSource* pgoSource)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getPgoInstrumentationResults(ftnHnd, ref *pSchema, ref *pCountSchemaItems, pInstrumentationData, ref *pgoSource);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static HRESULT _allocPgoInstrumentationBySchema(IntPtr thisHandle, IntPtr* ppException, CORINFO_METHOD_STRUCT_* ftnHnd, PgoInstrumentationSchema* pSchema, uint countSchemaItems, byte** pInstrumentationData)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.allocPgoInstrumentationBySchema(ftnHnd, pSchema, countSchemaItems, pInstrumentationData);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static void _recordCallSite(IntPtr thisHandle, IntPtr* ppException, uint instrOffset, CORINFO_SIG_INFO* callSig, CORINFO_METHOD_STRUCT_* methodHandle)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.recordCallSite(instrOffset, callSig, methodHandle);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static void _recordRelocation(IntPtr thisHandle, IntPtr* ppException, void* location, void* locationRW, void* target, ushort fRelocType, ushort slotNum, int addlDelta)
        {
            var _this = GetThis(thisHandle);
            try
            {
                _this.recordRelocation(location, locationRW, target, fRelocType, slotNum, addlDelta);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
            }
        }

        [UnmanagedCallersOnly]
        static ushort _getRelocTypeHint(IntPtr thisHandle, IntPtr* ppException, void* target)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getRelocTypeHint(target);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static uint _getExpectedTargetArchitecture(IntPtr thisHandle, IntPtr* ppException)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getExpectedTargetArchitecture();
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static uint _getJitFlags(IntPtr thisHandle, IntPtr* ppException, CORJIT_FLAGS* flags, uint sizeInBytes)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.getJitFlags(ref *flags, sizeInBytes);
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }

        [UnmanagedCallersOnly]
        static byte _doesFieldBelongToClass(IntPtr thisHandle, IntPtr* ppException, CORINFO_FIELD_STRUCT_* fldHnd, CORINFO_CLASS_STRUCT_* cls)
        {
            var _this = GetThis(thisHandle);
            try
            {
                return _this.doesFieldBelongToClass(fldHnd, cls) ? (byte)1 : (byte)0;
            }
            catch (Exception ex)
            {
                *ppException = _this.AllocException(ex);
                return default;
            }
        }


        static IntPtr GetUnmanagedCallbacks()
        {
            void** callbacks = (void**)Marshal.AllocCoTaskMem(sizeof(IntPtr) * 173);

            callbacks[0] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, byte>)&_isJitIntrinsic;
            callbacks[1] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, uint>)&_getMethodAttribs;
            callbacks[2] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, CorInfoMethodRuntimeFlags, void>)&_setMethodAttribs;
            callbacks[3] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, CORINFO_SIG_INFO*, CORINFO_CLASS_STRUCT_*, void>)&_getMethodSig;
            callbacks[4] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, CORINFO_METHOD_INFO*, byte>)&_getMethodInfo;
            callbacks[5] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, CORINFO_METHOD_STRUCT_*, uint*, CorInfoInline>)&_canInline;
            callbacks[6] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, CORINFO_METHOD_STRUCT_*, CorInfoInline, byte*, void>)&_reportInliningDecision;
            callbacks[7] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, CORINFO_METHOD_STRUCT_*, CORINFO_METHOD_STRUCT_*, byte, byte>)&_canTailCall;
            callbacks[8] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, CORINFO_METHOD_STRUCT_*, byte, CorInfoTailCall, byte*, void>)&_reportTailCallDecision;
            callbacks[9] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, uint, CORINFO_EH_CLAUSE*, void>)&_getEHinfo;
            callbacks[10] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, CORINFO_CLASS_STRUCT_*>)&_getMethodClass;
            callbacks[11] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, CORINFO_MODULE_STRUCT_*>)&_getMethodModule;
            callbacks[12] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, uint*, uint*, bool*, void>)&_getMethodVTableOffset;
            callbacks[13] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_DEVIRTUALIZATION_INFO*, byte>)&_resolveVirtualMethod;
            callbacks[14] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, bool*, CORINFO_METHOD_STRUCT_*>)&_getUnboxedEntry;
            callbacks[15] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, CORINFO_CLASS_STRUCT_*>)&_getDefaultComparerClass;
            callbacks[16] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, CORINFO_CLASS_STRUCT_*>)&_getDefaultEqualityComparerClass;
            callbacks[17] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_RESOLVED_TOKEN*, CORINFO_GENERICHANDLE_RESULT*, void>)&_expandRawHandleIntrinsic;
            callbacks[18] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, byte*, CorInfoIntrinsics>)&_getIntrinsicID;
            callbacks[19] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, byte>)&_isIntrinsicType;
            callbacks[20] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, CORINFO_SIG_INFO*, bool*, CorInfoCallConvExtension>)&_getUnmanagedCallConv;
            callbacks[21] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, CORINFO_SIG_INFO*, byte>)&_pInvokeMarshalingRequired;
            callbacks[22] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, CORINFO_METHOD_STRUCT_*, byte>)&_satisfiesMethodConstraints;
            callbacks[23] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, CORINFO_CLASS_STRUCT_*, CORINFO_METHOD_STRUCT_*, CORINFO_CLASS_STRUCT_*, bool*, byte>)&_isCompatibleDelegate;
            callbacks[24] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, void>)&_methodMustBeLoadedBeforeCodeIsRun;
            callbacks[25] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, CORINFO_METHOD_STRUCT_*>)&_mapMethodDeclToMethodImpl;
            callbacks[26] = (delegate* unmanaged<IntPtr, IntPtr*, IntPtr*, IntPtr**, void>)&_getGSCookie;
            callbacks[27] = (delegate* unmanaged<IntPtr, IntPtr*, PatchpointInfo*, void>)&_setPatchpointInfo;
            callbacks[28] = (delegate* unmanaged<IntPtr, IntPtr*, uint*, PatchpointInfo*>)&_getOSRInfo;
            callbacks[29] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_RESOLVED_TOKEN*, void>)&_resolveToken;
            callbacks[30] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_RESOLVED_TOKEN*, byte>)&_tryResolveToken;
            callbacks[31] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_MODULE_STRUCT_*, uint, CORINFO_CONTEXT_STRUCT*, CORINFO_SIG_INFO*, void>)&_findSig;
            callbacks[32] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_MODULE_STRUCT_*, uint, CORINFO_CONTEXT_STRUCT*, CORINFO_SIG_INFO*, void>)&_findCallSiteSig;
            callbacks[33] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_RESOLVED_TOKEN*, CORINFO_CLASS_STRUCT_*>)&_getTokenTypeAsHandle;
            callbacks[34] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_MODULE_STRUCT_*, uint, byte>)&_isValidToken;
            callbacks[35] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_MODULE_STRUCT_*, uint, byte>)&_isValidStringRef;
            callbacks[36] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_MODULE_STRUCT_*, uint, int*, char*>)&_getStringLiteral;
            callbacks[37] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, CorInfoType>)&_asCorInfoType;
            callbacks[38] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, byte*>)&_getClassName;
            callbacks[39] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, byte**, byte*>)&_getClassNameFromMetadata;
            callbacks[40] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, uint, CORINFO_CLASS_STRUCT_*>)&_getTypeInstantiationArgument;
            callbacks[41] = (delegate* unmanaged<IntPtr, IntPtr*, char**, int*, CORINFO_CLASS_STRUCT_*, byte, byte, byte, int>)&_appendClassName;
            callbacks[42] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, byte>)&_isValueClass;
            callbacks[43] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, CorInfoInlineTypeCheckSource, CorInfoInlineTypeCheck>)&_canInlineTypeCheck;
            callbacks[44] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, uint>)&_getClassAttribs;
            callbacks[45] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, byte>)&_isStructRequiringStackAllocRetBuf;
            callbacks[46] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, CORINFO_MODULE_STRUCT_*>)&_getClassModule;
            callbacks[47] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_MODULE_STRUCT_*, CORINFO_ASSEMBLY_STRUCT_*>)&_getModuleAssembly;
            callbacks[48] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_ASSEMBLY_STRUCT_*, byte*>)&_getAssemblyName;
            callbacks[49] = (delegate* unmanaged<IntPtr, IntPtr*, UIntPtr, void*>)&_LongLifetimeMalloc;
            callbacks[50] = (delegate* unmanaged<IntPtr, IntPtr*, void*, void>)&_LongLifetimeFree;
            callbacks[51] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, CORINFO_MODULE_STRUCT_**, void**, UIntPtr>)&_getClassModuleIdForStatics;
            callbacks[52] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, uint>)&_getClassSize;
            callbacks[53] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, uint>)&_getHeapClassSize;
            callbacks[54] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, byte>)&_canAllocateOnStack;
            callbacks[55] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, byte, uint>)&_getClassAlignmentRequirement;
            callbacks[56] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, byte*, uint>)&_getClassGClayout;
            callbacks[57] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, uint>)&_getClassNumInstanceFields;
            callbacks[58] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, int, CORINFO_FIELD_STRUCT_*>)&_getFieldInClass;
            callbacks[59] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, byte*, byte, byte>)&_checkMethodModifier;
            callbacks[60] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_RESOLVED_TOKEN*, CORINFO_METHOD_STRUCT_*, bool*, CorInfoHelpFunc>)&_getNewHelper;
            callbacks[61] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, CorInfoHelpFunc>)&_getNewArrHelper;
            callbacks[62] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_RESOLVED_TOKEN*, byte, CorInfoHelpFunc>)&_getCastingHelper;
            callbacks[63] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, CorInfoHelpFunc>)&_getSharedCCtorHelper;
            callbacks[64] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, CORINFO_CLASS_STRUCT_*>)&_getTypeForBox;
            callbacks[65] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, CorInfoHelpFunc>)&_getBoxHelper;
            callbacks[66] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, CorInfoHelpFunc>)&_getUnBoxHelper;
            callbacks[67] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_RESOLVED_TOKEN*, CORINFO_LOOKUP_KIND*, CorInfoHelpFunc, CORINFO_CONST_LOOKUP*, byte>)&_getReadyToRunHelper;
            callbacks[68] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_RESOLVED_TOKEN*, CORINFO_CLASS_STRUCT_*, CORINFO_LOOKUP*, void>)&_getReadyToRunDelegateCtorHelper;
            callbacks[69] = (delegate* unmanaged<IntPtr, IntPtr*, CorInfoHelpFunc, byte*>)&_getHelperName;
            callbacks[70] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_FIELD_STRUCT_*, CORINFO_METHOD_STRUCT_*, CORINFO_CONTEXT_STRUCT*, CorInfoInitClassResult>)&_initClass;
            callbacks[71] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, void>)&_classMustBeLoadedBeforeCodeIsRun;
            callbacks[72] = (delegate* unmanaged<IntPtr, IntPtr*, CorInfoClassId, CORINFO_CLASS_STRUCT_*>)&_getBuiltinClass;
            callbacks[73] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, CorInfoType>)&_getTypeForPrimitiveValueClass;
            callbacks[74] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, CorInfoType>)&_getTypeForPrimitiveNumericClass;
            callbacks[75] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, CORINFO_CLASS_STRUCT_*, byte>)&_canCast;
            callbacks[76] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, CORINFO_CLASS_STRUCT_*, byte>)&_areTypesEquivalent;
            callbacks[77] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, CORINFO_CLASS_STRUCT_*, TypeCompareState>)&_compareTypesForCast;
            callbacks[78] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, CORINFO_CLASS_STRUCT_*, TypeCompareState>)&_compareTypesForEquality;
            callbacks[79] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, CORINFO_CLASS_STRUCT_*, CORINFO_CLASS_STRUCT_*>)&_mergeClasses;
            callbacks[80] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, CORINFO_CLASS_STRUCT_*, byte>)&_isMoreSpecificType;
            callbacks[81] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, CORINFO_CLASS_STRUCT_*>)&_getParentType;
            callbacks[82] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, CORINFO_CLASS_STRUCT_**, CorInfoType>)&_getChildType;
            callbacks[83] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, byte>)&_satisfiesClassConstraints;
            callbacks[84] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, byte>)&_isSDArray;
            callbacks[85] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, uint>)&_getArrayRank;
            callbacks[86] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_FIELD_STRUCT_*, uint, void*>)&_getArrayInitializationData;
            callbacks[87] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_RESOLVED_TOKEN*, CORINFO_METHOD_STRUCT_*, CORINFO_HELPER_DESC*, CorInfoIsAccessAllowedResult>)&_canAccessClass;
            callbacks[88] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_FIELD_STRUCT_*, byte**, byte*>)&_getFieldName;
            callbacks[89] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_FIELD_STRUCT_*, CORINFO_CLASS_STRUCT_*>)&_getFieldClass;
            callbacks[90] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_FIELD_STRUCT_*, CORINFO_CLASS_STRUCT_**, CORINFO_CLASS_STRUCT_*, CorInfoType>)&_getFieldType;
            callbacks[91] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_FIELD_STRUCT_*, uint>)&_getFieldOffset;
            callbacks[92] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_RESOLVED_TOKEN*, CORINFO_METHOD_STRUCT_*, CORINFO_ACCESS_FLAGS, CORINFO_FIELD_INFO*, void>)&_getFieldInfo;
            callbacks[93] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_FIELD_STRUCT_*, byte>)&_isFieldStatic;
            callbacks[94] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, uint*, uint**, BoundaryTypes*, void>)&_getBoundaries;
            callbacks[95] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, uint, OffsetMapping*, void>)&_setBoundaries;
            callbacks[96] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, uint*, ILVarInfo**, bool*, void>)&_getVars;
            callbacks[97] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, uint, NativeVarInfo*, void>)&_setVars;
            callbacks[98] = (delegate* unmanaged<IntPtr, IntPtr*, UIntPtr, void*>)&_allocateArray;
            callbacks[99] = (delegate* unmanaged<IntPtr, IntPtr*, void*, void>)&_freeArray;
            callbacks[100] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_ARG_LIST_STRUCT_*, CORINFO_ARG_LIST_STRUCT_*>)&_getArgNext;
            callbacks[101] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_SIG_INFO*, CORINFO_ARG_LIST_STRUCT_*, CORINFO_CLASS_STRUCT_**, CorInfoTypeWithMod>)&_getArgType;
            callbacks[102] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_SIG_INFO*, CORINFO_ARG_LIST_STRUCT_*, CORINFO_CLASS_STRUCT_*>)&_getArgClass;
            callbacks[103] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, CorInfoHFAElemType>)&_getHFAType;
            callbacks[104] = (delegate* unmanaged<IntPtr, IntPtr*, _EXCEPTION_POINTERS*, HRESULT>)&_GetErrorHRESULT;
            callbacks[105] = (delegate* unmanaged<IntPtr, IntPtr*, char*, uint, uint>)&_GetErrorMessage;
            callbacks[106] = (delegate* unmanaged<IntPtr, IntPtr*, _EXCEPTION_POINTERS*, int>)&_FilterException;
            callbacks[107] = (delegate* unmanaged<IntPtr, IntPtr*, HRESULT, void>)&_ThrowExceptionForJitResult;
            callbacks[108] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_HELPER_DESC*, void>)&_ThrowExceptionForHelper;
            callbacks[109] = (delegate* unmanaged<IntPtr, IntPtr*, void*, void*, byte>)&_runWithErrorTrap;
            callbacks[110] = (delegate* unmanaged<IntPtr, IntPtr*, void*, void*, byte>)&_runWithSPMIErrorTrap;
            callbacks[111] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_EE_INFO*, void>)&_getEEInfo;
            callbacks[112] = (delegate* unmanaged<IntPtr, IntPtr*, char*>)&_getJitTimeLogFilename;
            callbacks[113] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, mdToken>)&_getMethodDefFromMethod;
            callbacks[114] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, byte**, byte*>)&_getMethodName;
            callbacks[115] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, byte**, byte**, byte**, byte*>)&_getMethodNameFromMetadata;
            callbacks[116] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, uint>)&_getMethodHash;
            callbacks[117] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_MODULE_STRUCT_*, mdToken, byte*, UIntPtr, UIntPtr>)&_findNameOfToken;
            callbacks[118] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, SYSTEMV_AMD64_CORINFO_STRUCT_REG_PASSING_DESCRIPTOR*, byte>)&_getSystemVAmd64PassStructInRegisterDescriptor;
            callbacks[119] = (delegate* unmanaged<IntPtr, IntPtr*, void**, uint>)&_getThreadTLSIndex;
            callbacks[120] = (delegate* unmanaged<IntPtr, IntPtr*, void**, void*>)&_getInlinedCallFrameVptr;
            callbacks[121] = (delegate* unmanaged<IntPtr, IntPtr*, void**, int*>)&_getAddrOfCaptureThreadGlobal;
            callbacks[122] = (delegate* unmanaged<IntPtr, IntPtr*, CorInfoHelpFunc, void**, void*>)&_getHelperFtn;
            callbacks[123] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, CORINFO_CONST_LOOKUP*, CORINFO_ACCESS_FLAGS, void>)&_getFunctionEntryPoint;
            callbacks[124] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, CORINFO_CONST_LOOKUP*, void>)&_getFunctionFixedEntryPoint;
            callbacks[125] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, void**, void*>)&_getMethodSync;
            callbacks[126] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_MODULE_STRUCT_*, CorInfoHelpFunc>)&_getLazyStringLiteralHelper;
            callbacks[127] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_MODULE_STRUCT_*, void**, CORINFO_MODULE_STRUCT_*>)&_embedModuleHandle;
            callbacks[128] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, void**, CORINFO_CLASS_STRUCT_*>)&_embedClassHandle;
            callbacks[129] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, void**, CORINFO_METHOD_STRUCT_*>)&_embedMethodHandle;
            callbacks[130] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_FIELD_STRUCT_*, void**, CORINFO_FIELD_STRUCT_*>)&_embedFieldHandle;
            callbacks[131] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_RESOLVED_TOKEN*, byte, CORINFO_GENERICHANDLE_RESULT*, void>)&_embedGenericHandle;
            callbacks[132] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, CORINFO_LOOKUP_KIND*, void>)&_getLocationOfThisType;
            callbacks[133] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, CORINFO_CONST_LOOKUP*, void>)&_getAddressOfPInvokeTarget;
            callbacks[134] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_SIG_INFO*, void**, void*>)&_GetCookieForPInvokeCalliSig;
            callbacks[135] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_SIG_INFO*, byte>)&_canGetCookieForPInvokeCalliSig;
            callbacks[136] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, CORINFO_JUST_MY_CODE_HANDLE_**, CORINFO_JUST_MY_CODE_HANDLE_*>)&_getJustMyCodeHandle;
            callbacks[137] = (delegate* unmanaged<IntPtr, IntPtr*, bool*, void**, bool*, void>)&_GetProfilingHandle;
            callbacks[138] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_RESOLVED_TOKEN*, CORINFO_RESOLVED_TOKEN*, CORINFO_METHOD_STRUCT_*, CORINFO_CALLINFO_FLAGS, CORINFO_CALL_INFO*, void>)&_getCallInfo;
            callbacks[139] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, CORINFO_CLASS_STRUCT_*, byte>)&_canAccessFamily;
            callbacks[140] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, byte>)&_isRIDClassDomainID;
            callbacks[141] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_CLASS_STRUCT_*, void**, uint>)&_getClassDomainID;
            callbacks[142] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_FIELD_STRUCT_*, void**, void*>)&_getFieldAddress;
            callbacks[143] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_FIELD_STRUCT_*, byte*, CORINFO_CLASS_STRUCT_*>)&_getStaticFieldCurrentClass;
            callbacks[144] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_SIG_INFO*, void**, IntPtr>)&_getVarArgsHandle;
            callbacks[145] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_SIG_INFO*, byte>)&_canGetVarArgsHandle;
            callbacks[146] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_MODULE_STRUCT_*, mdToken, void**, InfoAccessType>)&_constructStringLiteral;
            callbacks[147] = (delegate* unmanaged<IntPtr, IntPtr*, void**, InfoAccessType>)&_emptyStringLiteral;
            callbacks[148] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_FIELD_STRUCT_*, void**, uint>)&_getFieldThreadLocalStoreID;
            callbacks[149] = (delegate* unmanaged<IntPtr, IntPtr*, IntPtr, CORINFO_METHOD_STRUCT_*, void>)&_setOverride;
            callbacks[150] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_MODULE_STRUCT_*, CORINFO_MODULE_STRUCT_*, void>)&_addActiveDependency;
            callbacks[151] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, CORINFO_CLASS_STRUCT_*, CORINFO_METHOD_STRUCT_*, DelegateCtorArgs*, CORINFO_METHOD_STRUCT_*>)&_GetDelegateCtor;
            callbacks[152] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, void>)&_MethodCompileComplete;
            callbacks[153] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_RESOLVED_TOKEN*, CORINFO_SIG_INFO*, CORINFO_GET_TAILCALL_HELPERS_FLAGS, CORINFO_TAILCALL_HELPERS*, byte>)&_getTailCallHelpers;
            callbacks[154] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_RESOLVED_TOKEN*, byte, byte>)&_convertPInvokeCalliToCall;
            callbacks[155] = (delegate* unmanaged<IntPtr, IntPtr*, InstructionSet, byte, byte>)&_notifyInstructionSetUsage;
            callbacks[156] = (delegate* unmanaged<IntPtr, IntPtr*, AllocMemArgs*, void>)&_allocMem;
            callbacks[157] = (delegate* unmanaged<IntPtr, IntPtr*, byte, byte, uint, void>)&_reserveUnwindInfo;
            callbacks[158] = (delegate* unmanaged<IntPtr, IntPtr*, byte*, byte*, uint, uint, uint, byte*, CorJitFuncKind, void>)&_allocUnwindInfo;
            callbacks[159] = (delegate* unmanaged<IntPtr, IntPtr*, UIntPtr, void*>)&_allocGCInfo;
            callbacks[160] = (delegate* unmanaged<IntPtr, IntPtr*, uint, void>)&_setEHcount;
            callbacks[161] = (delegate* unmanaged<IntPtr, IntPtr*, uint, CORINFO_EH_CLAUSE*, void>)&_setEHinfo;
            callbacks[162] = (delegate* unmanaged<IntPtr, IntPtr*, uint, byte*, IntPtr, byte>)&_logMsg;
            callbacks[163] = (delegate* unmanaged<IntPtr, IntPtr*, byte*, int, byte*, int>)&_doAssert;
            callbacks[164] = (delegate* unmanaged<IntPtr, IntPtr*, CorJitResult, void>)&_reportFatalError;
            callbacks[165] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, PgoInstrumentationSchema**, uint*, byte**, PgoSource*, HRESULT>)&_getPgoInstrumentationResults;
            callbacks[166] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_METHOD_STRUCT_*, PgoInstrumentationSchema*, uint, byte**, HRESULT>)&_allocPgoInstrumentationBySchema;
            callbacks[167] = (delegate* unmanaged<IntPtr, IntPtr*, uint, CORINFO_SIG_INFO*, CORINFO_METHOD_STRUCT_*, void>)&_recordCallSite;
            callbacks[168] = (delegate* unmanaged<IntPtr, IntPtr*, void*, void*, void*, ushort, ushort, int, void>)&_recordRelocation;
            callbacks[169] = (delegate* unmanaged<IntPtr, IntPtr*, void*, ushort>)&_getRelocTypeHint;
            callbacks[170] = (delegate* unmanaged<IntPtr, IntPtr*, uint>)&_getExpectedTargetArchitecture;
            callbacks[171] = (delegate* unmanaged<IntPtr, IntPtr*, CORJIT_FLAGS*, uint, uint>)&_getJitFlags;
            callbacks[172] = (delegate* unmanaged<IntPtr, IntPtr*, CORINFO_FIELD_STRUCT_*, CORINFO_CLASS_STRUCT_*, byte>)&_doesFieldBelongToClass;

            return (IntPtr)callbacks;
        }
    }
}

